@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.extendedlocation.kotlin

import com.pulumi.azurenative.extendedlocation.ExtendedlocationFunctions.getCustomLocationPlain
import com.pulumi.azurenative.extendedlocation.ExtendedlocationFunctions.getResourceSyncRulePlain
import com.pulumi.azurenative.extendedlocation.kotlin.inputs.GetCustomLocationPlainArgs
import com.pulumi.azurenative.extendedlocation.kotlin.inputs.GetCustomLocationPlainArgsBuilder
import com.pulumi.azurenative.extendedlocation.kotlin.inputs.GetResourceSyncRulePlainArgs
import com.pulumi.azurenative.extendedlocation.kotlin.inputs.GetResourceSyncRulePlainArgsBuilder
import com.pulumi.azurenative.extendedlocation.kotlin.outputs.GetCustomLocationResult
import com.pulumi.azurenative.extendedlocation.kotlin.outputs.GetResourceSyncRuleResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.extendedlocation.kotlin.outputs.GetCustomLocationResult.Companion.toKotlin as getCustomLocationResultToKotlin
import com.pulumi.azurenative.extendedlocation.kotlin.outputs.GetResourceSyncRuleResult.Companion.toKotlin as getResourceSyncRuleResultToKotlin

public object ExtendedlocationFunctions {
    /**
     * Gets the details of the customLocation with a specified resource group and name.
     * Azure REST API version: 2021-08-15.
     * Other available API versions: 2021-08-31-preview.
     * @param argument null
     * @return Custom Locations definition.
     */
    public suspend fun getCustomLocation(argument: GetCustomLocationPlainArgs): GetCustomLocationResult =
        getCustomLocationResultToKotlin(getCustomLocationPlain(argument.toJava()).await())

    /**
     * @see [getCustomLocation].
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName Custom Locations name.
     * @return Custom Locations definition.
     */
    public suspend fun getCustomLocation(resourceGroupName: String, resourceName: String): GetCustomLocationResult {
        val argument = GetCustomLocationPlainArgs(
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getCustomLocationResultToKotlin(getCustomLocationPlain(argument.toJava()).await())
    }

    /**
     * @see [getCustomLocation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;extendedlocation&#46;kotlin&#46;inputs&#46;GetCustomLocationPlainArgs].
     * @return Custom Locations definition.
     */
    public suspend fun getCustomLocation(argument: suspend GetCustomLocationPlainArgsBuilder.() -> Unit): GetCustomLocationResult {
        val builder = GetCustomLocationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCustomLocationResultToKotlin(getCustomLocationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the details of the resourceSyncRule with a specified resource group, subscription id Custom Location resource name and Resource Sync Rule name.
     * Azure REST API version: 2021-08-31-preview.
     * @param argument null
     * @return Resource Sync Rules definition.
     */
    public suspend fun getResourceSyncRule(argument: GetResourceSyncRulePlainArgs): GetResourceSyncRuleResult =
        getResourceSyncRuleResultToKotlin(getResourceSyncRulePlain(argument.toJava()).await())

    /**
     * @see [getResourceSyncRule].
     * @param childResourceName Resource Sync Rule name.
     * @param resourceGroupName The name of the resource group. The name is case insensitive.
     * @param resourceName Custom Locations name.
     * @return Resource Sync Rules definition.
     */
    public suspend fun getResourceSyncRule(
        childResourceName: String,
        resourceGroupName: String,
        resourceName: String,
    ): GetResourceSyncRuleResult {
        val argument = GetResourceSyncRulePlainArgs(
            childResourceName = childResourceName,
            resourceGroupName = resourceGroupName,
            resourceName = resourceName,
        )
        return getResourceSyncRuleResultToKotlin(getResourceSyncRulePlain(argument.toJava()).await())
    }

    /**
     * @see [getResourceSyncRule].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;extendedlocation&#46;kotlin&#46;inputs&#46;GetResourceSyncRulePlainArgs].
     * @return Resource Sync Rules definition.
     */
    public suspend fun getResourceSyncRule(argument: suspend GetResourceSyncRulePlainArgsBuilder.() -> Unit): GetResourceSyncRuleResult {
        val builder = GetResourceSyncRulePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getResourceSyncRuleResultToKotlin(getResourceSyncRulePlain(builtArgument.toJava()).await())
    }
}
