@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.extendedlocation.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Resource Sync Rules definition.
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property priority Priority represents a priority of the Resource Sync Rule
 * @property provisioningState Provisioning State for the Resource Sync Rule.
 * @property selector A label selector is composed of two parts, matchLabels and matchExpressions. The first part, matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is 'key', the operator is 'In', and the values array contains only 'value'. The second part, matchExpressions is a list of resource selector requirements. Valid operators include In, NotIn, Exists, and DoesNotExist. The values set must be non-empty in the case of In and NotIn. The values set must be empty in the case of Exists and DoesNotExist. All of the requirements, from both matchLabels and matchExpressions must all be satisfied in order to match.
 * @property systemData Metadata pertaining to creation and last modification of the resource
 * @property tags Resource tags.
 * @property targetResourceGroup For an unmapped custom resource, its labels will be used to find matching resource sync rules. If this resource sync rule is one of the matching rules with highest priority, then the unmapped custom resource will be projected to the target resource group associated with this resource sync rule. The user creating this resource sync rule should have write permissions on the target resource group and this write permission will be validated when creating the resource sync rule.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetResourceSyncRuleResult(
    public val id: String,
    public val location: String,
    public val name: String,
    public val priority: Int? = null,
    public val provisioningState: String,
    public val selector: ResourceSyncRulePropertiesResponseSelector? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val targetResourceGroup: String? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.extendedlocation.outputs.GetResourceSyncRuleResult): GetResourceSyncRuleResult = GetResourceSyncRuleResult(
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            priority = javaType.priority().map({ args0 -> args0 }).orElse(null),
            provisioningState = javaType.provisioningState(),
            selector = javaType.selector().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.extendedlocation.kotlin.outputs.ResourceSyncRulePropertiesResponseSelector.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.extendedlocation.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            targetResourceGroup = javaType.targetResourceGroup().map({ args0 -> args0 }).orElse(null),
            type = javaType.type(),
        )
    }
}
