@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.extendedlocation.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A label selector is composed of two parts, matchLabels and matchExpressions. The first part, matchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is 'key', the operator is 'In', and the values array contains only 'value'. The second part, matchExpressions is a list of resource selector requirements. Valid operators include In, NotIn, Exists, and DoesNotExist. The values set must be non-empty in the case of In and NotIn. The values set must be empty in the case of Exists and DoesNotExist. All of the requirements, from both matchLabels and matchExpressions must all be satisfied in order to match.
 * @property matchLabels MatchLabels is a map of {key,value} pairs. A single {key,value} in the matchLabels map is equivalent to an element of matchExpressions, whose key field is 'key', the operator is 'In', and the values array contains only 'value'.
 */
public data class ResourceSyncRulePropertiesResponseSelector(
    public val matchLabels: Map<String, String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.extendedlocation.outputs.ResourceSyncRulePropertiesResponseSelector): ResourceSyncRulePropertiesResponseSelector = ResourceSyncRulePropertiesResponseSelector(
            matchLabels = javaType.matchLabels().map({ args0 -> args0.key.to(args0.value) }).toMap(),
        )
    }
}
