@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.features.kotlin

import com.pulumi.azurenative.features.kotlin.outputs.SubscriptionFeatureRegistrationResponseProperties
import com.pulumi.azurenative.features.kotlin.outputs.SubscriptionFeatureRegistrationResponseProperties.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [SubscriptionFeatureRegistration].
 */
@PulumiTagMarker
public class SubscriptionFeatureRegistrationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: SubscriptionFeatureRegistrationArgs = SubscriptionFeatureRegistrationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend SubscriptionFeatureRegistrationArgsBuilder.() -> Unit) {
        val builder = SubscriptionFeatureRegistrationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): SubscriptionFeatureRegistration {
        val builtJavaResource =
            com.pulumi.azurenative.features.SubscriptionFeatureRegistration(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return SubscriptionFeatureRegistration(builtJavaResource)
    }
}

/**
 * Subscription feature registration details
 * Azure REST API version: 2021-07-01. Prior API version in Azure Native 1.x: 2021-07-01.
 * ## Example Usage
 * ### Creates a feature registration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subscriptionFeatureRegistration = new AzureNative.Features.SubscriptionFeatureRegistration("subscriptionFeatureRegistration", new()
 *     {
 *         FeatureName = "testFeature",
 *         Properties = null,
 *         ProviderNamespace = "subscriptionFeatureRegistrationGroupTestRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/features/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := features.NewSubscriptionFeatureRegistration(ctx, "subscriptionFeatureRegistration", &features.SubscriptionFeatureRegistrationArgs{
 * 			FeatureName:       pulumi.String("testFeature"),
 * 			Properties:        nil,
 * 			ProviderNamespace: pulumi.String("subscriptionFeatureRegistrationGroupTestRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.features.SubscriptionFeatureRegistration;
 * import com.pulumi.azurenative.features.SubscriptionFeatureRegistrationArgs;
 * import com.pulumi.azurenative.features.inputs.SubscriptionFeatureRegistrationPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subscriptionFeatureRegistration = new SubscriptionFeatureRegistration("subscriptionFeatureRegistration", SubscriptionFeatureRegistrationArgs.builder()
 *             .featureName("testFeature")
 *             .properties()
 *             .providerNamespace("subscriptionFeatureRegistrationGroupTestRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:features:SubscriptionFeatureRegistration testFeature /subscriptions/{subscriptionId}/providers/Microsoft.Features/featureProviders/{providerNamespace}/subscriptionFeatureRegistrations/{featureName}
 * ```
 */
public class SubscriptionFeatureRegistration internal constructor(
    override val javaResource: com.pulumi.azurenative.features.SubscriptionFeatureRegistration,
) : KotlinCustomResource(javaResource, SubscriptionFeatureRegistrationMapper) {
    /**
     * Azure resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    public val properties: Output<SubscriptionFeatureRegistrationResponseProperties>
        get() = javaResource.properties().applyValue({ args0 -> args0.let({ args0 -> toKotlin(args0) }) })

    /**
     * Azure resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object SubscriptionFeatureRegistrationMapper :
    ResourceMapper<SubscriptionFeatureRegistration> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.features.SubscriptionFeatureRegistration::class == javaResource::class

    override fun map(javaResource: Resource): SubscriptionFeatureRegistration =
        SubscriptionFeatureRegistration(
            javaResource as
                com.pulumi.azurenative.features.SubscriptionFeatureRegistration,
        )
}

/**
 * @see [SubscriptionFeatureRegistration].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [SubscriptionFeatureRegistration].
 */
public suspend fun subscriptionFeatureRegistration(
    name: String,
    block: suspend SubscriptionFeatureRegistrationResourceBuilder.() -> Unit,
): SubscriptionFeatureRegistration {
    val builder = SubscriptionFeatureRegistrationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [SubscriptionFeatureRegistration].
 * @param name The _unique_ name of the resulting resource.
 */
public fun subscriptionFeatureRegistration(name: String): SubscriptionFeatureRegistration {
    val builder = SubscriptionFeatureRegistrationResourceBuilder()
    builder.name(name)
    return builder.build()
}
