@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.features.kotlin

import com.pulumi.azurenative.features.SubscriptionFeatureRegistrationArgs.builder
import com.pulumi.azurenative.features.kotlin.inputs.SubscriptionFeatureRegistrationPropertiesArgs
import com.pulumi.azurenative.features.kotlin.inputs.SubscriptionFeatureRegistrationPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Subscription feature registration details
 * Azure REST API version: 2021-07-01. Prior API version in Azure Native 1.x: 2021-07-01.
 * ## Example Usage
 * ### Creates a feature registration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var subscriptionFeatureRegistration = new AzureNative.Features.SubscriptionFeatureRegistration("subscriptionFeatureRegistration", new()
 *     {
 *         FeatureName = "testFeature",
 *         Properties = null,
 *         ProviderNamespace = "subscriptionFeatureRegistrationGroupTestRG",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/features/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := features.NewSubscriptionFeatureRegistration(ctx, "subscriptionFeatureRegistration", &features.SubscriptionFeatureRegistrationArgs{
 * 			FeatureName:       pulumi.String("testFeature"),
 * 			Properties:        nil,
 * 			ProviderNamespace: pulumi.String("subscriptionFeatureRegistrationGroupTestRG"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.features.SubscriptionFeatureRegistration;
 * import com.pulumi.azurenative.features.SubscriptionFeatureRegistrationArgs;
 * import com.pulumi.azurenative.features.inputs.SubscriptionFeatureRegistrationPropertiesArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var subscriptionFeatureRegistration = new SubscriptionFeatureRegistration("subscriptionFeatureRegistration", SubscriptionFeatureRegistrationArgs.builder()
 *             .featureName("testFeature")
 *             .properties()
 *             .providerNamespace("subscriptionFeatureRegistrationGroupTestRG")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:features:SubscriptionFeatureRegistration testFeature /subscriptions/{subscriptionId}/providers/Microsoft.Features/featureProviders/{providerNamespace}/subscriptionFeatureRegistrations/{featureName}
 * ```
 * @property featureName The feature name.
 * @property properties
 * @property providerNamespace The provider namespace.
 */
public data class SubscriptionFeatureRegistrationArgs(
    public val featureName: Output<String>? = null,
    public val properties: Output<SubscriptionFeatureRegistrationPropertiesArgs>? = null,
    public val providerNamespace: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.features.SubscriptionFeatureRegistrationArgs> {
    override fun toJava(): com.pulumi.azurenative.features.SubscriptionFeatureRegistrationArgs =
        com.pulumi.azurenative.features.SubscriptionFeatureRegistrationArgs.builder()
            .featureName(featureName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .providerNamespace(providerNamespace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SubscriptionFeatureRegistrationArgs].
 */
@PulumiTagMarker
public class SubscriptionFeatureRegistrationArgsBuilder internal constructor() {
    private var featureName: Output<String>? = null

    private var properties: Output<SubscriptionFeatureRegistrationPropertiesArgs>? = null

    private var providerNamespace: Output<String>? = null

    /**
     * @param value The feature name.
     */
    @JvmName("mwbbdeopvvwoagth")
    public suspend fun featureName(`value`: Output<String>) {
        this.featureName = value
    }

    /**
     * @param value
     */
    @JvmName("okjkudgsumytotbw")
    public suspend fun properties(`value`: Output<SubscriptionFeatureRegistrationPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The provider namespace.
     */
    @JvmName("pduosiuogphkflan")
    public suspend fun providerNamespace(`value`: Output<String>) {
        this.providerNamespace = value
    }

    /**
     * @param value The feature name.
     */
    @JvmName("cvmwkxuksxtkrnnw")
    public suspend fun featureName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.featureName = mapped
    }

    /**
     * @param value
     */
    @JvmName("nsyojycqtostvchw")
    public suspend fun properties(`value`: SubscriptionFeatureRegistrationPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument
     */
    @JvmName("bbhgwnfetnnosbaj")
    public suspend fun properties(argument: suspend SubscriptionFeatureRegistrationPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = SubscriptionFeatureRegistrationPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The provider namespace.
     */
    @JvmName("xinimibmrotaopyq")
    public suspend fun providerNamespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerNamespace = mapped
    }

    internal fun build(): SubscriptionFeatureRegistrationArgs = SubscriptionFeatureRegistrationArgs(
        featureName = featureName,
        properties = properties,
        providerNamespace = providerNamespace,
    )
}
