@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.features.kotlin.inputs

import com.pulumi.azurenative.features.inputs.SubscriptionFeatureRegistrationPropertiesArgs.builder
import com.pulumi.azurenative.features.kotlin.enums.SubscriptionFeatureRegistrationState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property description The feature description.
 * @property metadata Key-value pairs for meta data.
 * @property shouldFeatureDisplayInPortal Indicates whether feature should be displayed in Portal.
 * @property state The state.
 */
public data class SubscriptionFeatureRegistrationPropertiesArgs(
    public val description: Output<String>? = null,
    public val metadata: Output<Map<String, String>>? = null,
    public val shouldFeatureDisplayInPortal: Output<Boolean>? = null,
    public val state: Output<Either<String, SubscriptionFeatureRegistrationState>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.features.inputs.SubscriptionFeatureRegistrationPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.features.inputs.SubscriptionFeatureRegistrationPropertiesArgs =
        com.pulumi.azurenative.features.inputs.SubscriptionFeatureRegistrationPropertiesArgs.builder()
            .description(description?.applyValue({ args0 -> args0 }))
            .metadata(
                metadata?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .shouldFeatureDisplayInPortal(shouldFeatureDisplayInPortal?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [SubscriptionFeatureRegistrationPropertiesArgs].
 */
@PulumiTagMarker
public class SubscriptionFeatureRegistrationPropertiesArgsBuilder internal constructor() {
    private var description: Output<String>? = null

    private var metadata: Output<Map<String, String>>? = null

    private var shouldFeatureDisplayInPortal: Output<Boolean>? = null

    private var state: Output<Either<String, SubscriptionFeatureRegistrationState>>? = null

    /**
     * @param value The feature description.
     */
    @JvmName("wvhqtydrrqkkradk")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Key-value pairs for meta data.
     */
    @JvmName("nhqinhulxdivmryy")
    public suspend fun metadata(`value`: Output<Map<String, String>>) {
        this.metadata = value
    }

    /**
     * @param value Indicates whether feature should be displayed in Portal.
     */
    @JvmName("cgweuxvblfehdkfb")
    public suspend fun shouldFeatureDisplayInPortal(`value`: Output<Boolean>) {
        this.shouldFeatureDisplayInPortal = value
    }

    /**
     * @param value The state.
     */
    @JvmName("vwjxvfojcjmrsgve")
    public suspend fun state(`value`: Output<Either<String, SubscriptionFeatureRegistrationState>>) {
        this.state = value
    }

    /**
     * @param value The feature description.
     */
    @JvmName("oceytgoledrcxqpc")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Key-value pairs for meta data.
     */
    @JvmName("scuoipluufnpoqvw")
    public suspend fun metadata(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param values Key-value pairs for meta data.
     */
    @JvmName("bkwwfxqqogeqwvua")
    public fun metadata(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metadata = mapped
    }

    /**
     * @param value Indicates whether feature should be displayed in Portal.
     */
    @JvmName("rxvfhqkwalvvckqs")
    public suspend fun shouldFeatureDisplayInPortal(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.shouldFeatureDisplayInPortal = mapped
    }

    /**
     * @param value The state.
     */
    @JvmName("ahupyjdckjoykswc")
    public suspend fun state(`value`: Either<String, SubscriptionFeatureRegistrationState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The state.
     */
    @JvmName("smykpktnagrohrei")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, SubscriptionFeatureRegistrationState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value The state.
     */
    @JvmName("jqajefaabdmraabo")
    public fun state(`value`: SubscriptionFeatureRegistrationState) {
        val toBeMapped = Either.ofRight<String, SubscriptionFeatureRegistrationState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    internal fun build(): SubscriptionFeatureRegistrationPropertiesArgs =
        SubscriptionFeatureRegistrationPropertiesArgs(
            description = description,
            metadata = metadata,
            shouldFeatureDisplayInPortal = shouldFeatureDisplayInPortal,
            state = state,
        )
}
