@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.features.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Subscription feature registration details
 * @property id Azure resource Id.
 * @property name Azure resource name.
 * @property properties
 * @property type Azure resource type.
 */
public data class GetSubscriptionFeatureRegistrationResult(
    public val id: String,
    public val name: String,
    public val properties: SubscriptionFeatureRegistrationResponseProperties,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.features.outputs.GetSubscriptionFeatureRegistrationResult): GetSubscriptionFeatureRegistrationResult = GetSubscriptionFeatureRegistrationResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.features.kotlin.outputs.SubscriptionFeatureRegistrationResponseProperties.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
