@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.fluidrelay.kotlin.inputs

import com.pulumi.azurenative.fluidrelay.inputs.CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgs.builder
import com.pulumi.azurenative.fluidrelay.kotlin.enums.CmkIdentityType
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * All identity configuration for Customer-managed key settings defining which identity should be used to auth to Key Vault.
 * @property identityType Values can be SystemAssigned or UserAssigned
 * @property userAssignedIdentityResourceId user assigned identity to use for accessing key encryption key Url. Ex: /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/<resource group>/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId. Mutually exclusive with identityType systemAssignedIdentity.
 */
public data class CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgs(
    public val identityType: Output<CmkIdentityType>? = null,
    public val userAssignedIdentityResourceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.fluidrelay.inputs.CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.fluidrelay.inputs.CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgs =
        com.pulumi.azurenative.fluidrelay.inputs.CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgs.builder()
            .identityType(identityType?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .userAssignedIdentityResourceId(
                userAssignedIdentityResourceId?.applyValue({ args0 ->
                    args0
                }),
            ).build()
}

/**
 * Builder for [CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgs].
 */
@PulumiTagMarker
public class CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgsBuilder internal constructor() {
    private var identityType: Output<CmkIdentityType>? = null

    private var userAssignedIdentityResourceId: Output<String>? = null

    /**
     * @param value Values can be SystemAssigned or UserAssigned
     */
    @JvmName("nvuilqgcvuofspod")
    public suspend fun identityType(`value`: Output<CmkIdentityType>) {
        this.identityType = value
    }

    /**
     * @param value user assigned identity to use for accessing key encryption key Url. Ex: /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/<resource group>/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId. Mutually exclusive with identityType systemAssignedIdentity.
     */
    @JvmName("agvbavejlbkbvrum")
    public suspend fun userAssignedIdentityResourceId(`value`: Output<String>) {
        this.userAssignedIdentityResourceId = value
    }

    /**
     * @param value Values can be SystemAssigned or UserAssigned
     */
    @JvmName("nwltigjgqnswpvwy")
    public suspend fun identityType(`value`: CmkIdentityType?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.identityType = mapped
    }

    /**
     * @param value user assigned identity to use for accessing key encryption key Url. Ex: /subscriptions/fa5fc227-a624-475e-b696-cdd604c735bc/resourceGroups/<resource group>/providers/Microsoft.ManagedIdentity/userAssignedIdentities/myId. Mutually exclusive with identityType systemAssignedIdentity.
     */
    @JvmName("lgjmxtrtaarvisnb")
    public suspend fun userAssignedIdentityResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentityResourceId = mapped
    }

    internal fun build(): CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgs =
        CustomerManagedKeyEncryptionPropertiesKeyEncryptionKeyIdentityArgs(
            identityType = identityType,
            userAssignedIdentityResourceId = userAssignedIdentityResourceId,
        )
}
