@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.fluidrelay.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The Fluid Relay endpoints for this server
 * @property ordererEndpoints The Fluid Relay Orderer endpoints.
 * @property serviceEndpoints The Fluid Relay service endpoints.
 * @property storageEndpoints The Fluid Relay storage endpoints.
 */
public data class FluidRelayEndpointsResponse(
    public val ordererEndpoints: List<String>,
    public val serviceEndpoints: List<String>,
    public val storageEndpoints: List<String>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.fluidrelay.outputs.FluidRelayEndpointsResponse): FluidRelayEndpointsResponse = FluidRelayEndpointsResponse(
            ordererEndpoints = javaType.ordererEndpoints().map({ args0 -> args0 }),
            serviceEndpoints = javaType.serviceEndpoints().map({ args0 -> args0 }),
            storageEndpoints = javaType.storageEndpoints().map({ args0 -> args0 }),
        )
    }
}
