@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.fluidrelay.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * A FluidRelay Server.
 * @property encryption All encryption configuration for a resource.
 * @property fluidRelayEndpoints The Fluid Relay Service endpoints for this server.
 * @property frsTenantId The Fluid tenantId for this server
 * @property id Fully qualified resource ID for the resource. Ex - /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}
 * @property identity The type of identity used for the resource.
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property provisioningState Provision states for FluidRelay RP
 * @property storagesku Sku of the storage associated with the resource
 * @property systemData System meta data for this resource, including creation and modification information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetFluidRelayServerResult(
    public val encryption: EncryptionPropertiesResponse? = null,
    public val fluidRelayEndpoints: FluidRelayEndpointsResponse,
    public val frsTenantId: String,
    public val id: String,
    public val identity: IdentityResponse? = null,
    public val location: String,
    public val name: String,
    public val provisioningState: String? = null,
    public val storagesku: String? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.fluidrelay.outputs.GetFluidRelayServerResult): GetFluidRelayServerResult = GetFluidRelayServerResult(
            encryption = javaType.encryption().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.fluidrelay.kotlin.outputs.EncryptionPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            fluidRelayEndpoints = javaType.fluidRelayEndpoints().let({ args0 ->
                com.pulumi.azurenative.fluidrelay.kotlin.outputs.FluidRelayEndpointsResponse.Companion.toKotlin(args0)
            }),
            frsTenantId = javaType.frsTenantId(),
            id = javaType.id(),
            identity = javaType.identity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.fluidrelay.kotlin.outputs.IdentityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            location = javaType.location(),
            name = javaType.name(),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            storagesku = javaType.storagesku().map({ args0 -> args0 }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.fluidrelay.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
