@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.graphservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Property bag from billing account
 * @property appId Customer owned application ID
 * @property billingPlanId Billing Plan Id
 * @property provisioningState Provisioning state.
 */
public data class AccountResourceResponseProperties(
    public val appId: String,
    public val billingPlanId: String,
    public val provisioningState: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.graphservices.outputs.AccountResourceResponseProperties): AccountResourceResponseProperties = AccountResourceResponseProperties(
            appId = javaType.appId(),
            billingPlanId = javaType.billingPlanId(),
            provisioningState = javaType.provisioningState(),
        )
    }
}
