@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.graphservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Metadata pertaining to creation and last modification of the resource.
 * @property createdAt The timestamp of resource creation (UTC).
 * @property createdByType The type of identity that created the resource.
 * @property lastModifiedAt The timestamp of resource last modification (UTC)
 * @property lastModifiedByType The type of identity that last modified the resource.
 */
public data class AccountResourceResponseSystemData(
    public val createdAt: String? = null,
    public val createdByType: String? = null,
    public val lastModifiedAt: String? = null,
    public val lastModifiedByType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.graphservices.outputs.AccountResourceResponseSystemData): AccountResourceResponseSystemData = AccountResourceResponseSystemData(
            createdAt = javaType.createdAt().map({ args0 -> args0 }).orElse(null),
            createdByType = javaType.createdByType().map({ args0 -> args0 }).orElse(null),
            lastModifiedAt = javaType.lastModifiedAt().map({ args0 -> args0 }).orElse(null),
            lastModifiedByType = javaType.lastModifiedByType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
