@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.graphservices.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * Account details
 * @property id Azure resource ID.
 * @property location Location of the resource.
 * @property name Azure resource name.
 * @property properties Property bag from billing account
 * @property systemData Metadata pertaining to creation and last modification of the resource.
 * @property tags resource tags.
 * @property type Azure resource type.
 */
public data class GetAccountResult(
    public val id: String,
    public val location: String? = null,
    public val name: String,
    public val properties: AccountResourceResponseProperties,
    public val systemData: AccountResourceResponseSystemData,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.graphservices.outputs.GetAccountResult): GetAccountResult = GetAccountResult(
            id = javaType.id(),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.graphservices.kotlin.outputs.AccountResourceResponseProperties.Companion.toKotlin(args0)
            }),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.graphservices.kotlin.outputs.AccountResourceResponseSystemData.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
