@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin

import com.pulumi.azurenative.guestconfiguration.GuestConfigurationHCRPAssignmentArgs.builder
import com.pulumi.azurenative.guestconfiguration.kotlin.inputs.GuestConfigurationAssignmentPropertiesArgs
import com.pulumi.azurenative.guestconfiguration.kotlin.inputs.GuestConfigurationAssignmentPropertiesArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Guest configuration assignment is an association between a machine and guest configuration.
 * Azure REST API version: 2022-01-25. Prior API version in Azure Native 1.x: 2020-06-25.
 * ## Example Usage
 * ### Create or update guest configuration assignment
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var guestConfigurationHCRPAssignment = new AzureNative.GuestConfiguration.GuestConfigurationHCRPAssignment("guestConfigurationHCRPAssignment", new()
 *     {
 *         GuestConfigurationAssignmentName = "NotInstalledApplicationForWindows",
 *         Location = "westcentralus",
 *         MachineName = "myMachineName",
 *         Name = "NotInstalledApplicationForWindows",
 *         Properties = new AzureNative.GuestConfiguration.Inputs.GuestConfigurationAssignmentPropertiesArgs
 *         {
 *             Context = "Azure policy",
 *             GuestConfiguration = new AzureNative.GuestConfiguration.Inputs.GuestConfigurationNavigationArgs
 *             {
 *                 AssignmentType = AzureNative.GuestConfiguration.AssignmentType.ApplyAndAutoCorrect,
 *                 ConfigurationParameter = new[]
 *                 {
 *                     new AzureNative.GuestConfiguration.Inputs.ConfigurationParameterArgs
 *                     {
 *                         Name = "[InstalledApplication]NotInstalledApplicationResource1;Name",
 *                         Value = "NotePad,sql",
 *                     },
 *                 },
 *                 ContentHash = "123contenthash",
 *                 ContentUri = "https://thisisfake/pacakge",
 *                 Name = "NotInstalledApplicationForWindows",
 *                 Version = "1.0.0.3",
 *             },
 *         },
 *         ResourceGroupName = "myResourceGroupName",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/guestconfiguration/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := guestconfiguration.NewGuestConfigurationHCRPAssignment(ctx, "guestConfigurationHCRPAssignment", &guestconfiguration.GuestConfigurationHCRPAssignmentArgs{
 * 			GuestConfigurationAssignmentName: pulumi.String("NotInstalledApplicationForWindows"),
 * 			Location:                         pulumi.String("westcentralus"),
 * 			MachineName:                      pulumi.String("myMachineName"),
 * 			Name:                             pulumi.String("NotInstalledApplicationForWindows"),
 * 			Properties: &guestconfiguration.GuestConfigurationAssignmentPropertiesArgs{
 * 				Context: pulumi.String("Azure policy"),
 * 				GuestConfiguration: &guestconfiguration.GuestConfigurationNavigationArgs{
 * 					AssignmentType: pulumi.String(guestconfiguration.AssignmentTypeApplyAndAutoCorrect),
 * 					ConfigurationParameter: guestconfiguration.ConfigurationParameterArray{
 * 						&guestconfiguration.ConfigurationParameterArgs{
 * 							Name:  pulumi.String("[InstalledApplication]NotInstalledApplicationResource1;Name"),
 * 							Value: pulumi.String("NotePad,sql"),
 * 						},
 * 					},
 * 					ContentHash: pulumi.String("123contenthash"),
 * 					ContentUri:  pulumi.String("https://thisisfake/pacakge"),
 * 					Name:        pulumi.String("NotInstalledApplicationForWindows"),
 * 					Version:     pulumi.String("1.0.0.3"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("myResourceGroupName"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.guestconfiguration.GuestConfigurationHCRPAssignment;
 * import com.pulumi.azurenative.guestconfiguration.GuestConfigurationHCRPAssignmentArgs;
 * import com.pulumi.azurenative.guestconfiguration.inputs.GuestConfigurationAssignmentPropertiesArgs;
 * import com.pulumi.azurenative.guestconfiguration.inputs.GuestConfigurationNavigationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var guestConfigurationHCRPAssignment = new GuestConfigurationHCRPAssignment("guestConfigurationHCRPAssignment", GuestConfigurationHCRPAssignmentArgs.builder()
 *             .guestConfigurationAssignmentName("NotInstalledApplicationForWindows")
 *             .location("westcentralus")
 *             .machineName("myMachineName")
 *             .name("NotInstalledApplicationForWindows")
 *             .properties(GuestConfigurationAssignmentPropertiesArgs.builder()
 *                 .context("Azure policy")
 *                 .guestConfiguration(GuestConfigurationNavigationArgs.builder()
 *                     .assignmentType("ApplyAndAutoCorrect")
 *                     .configurationParameter(ConfigurationParameterArgs.builder()
 *                         .name("[InstalledApplication]NotInstalledApplicationResource1;Name")
 *                         .value("NotePad,sql")
 *                         .build())
 *                     .contentHash("123contenthash")
 *                     .contentUri("https://thisisfake/pacakge")
 *                     .name("NotInstalledApplicationForWindows")
 *                     .version("1.0.0.3")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("myResourceGroupName")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:guestconfiguration:GuestConfigurationHCRPAssignment NotInstalledApplicationForWindows /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HybridCompute/machines/{machineName}/providers/Microsoft.GuestConfiguration/guestConfigurationAssignments/{guestConfigurationAssignmentName}
 * ```
 * @property guestConfigurationAssignmentName Name of the guest configuration assignment.
 * @property location Region where the VM is located.
 * @property machineName The name of the ARC machine.
 * @property name Name of the guest configuration assignment.
 * @property properties Properties of the Guest configuration assignment.
 * @property resourceGroupName The resource group name.
 */
public data class GuestConfigurationHCRPAssignmentArgs(
    public val guestConfigurationAssignmentName: Output<String>? = null,
    public val location: Output<String>? = null,
    public val machineName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val properties: Output<GuestConfigurationAssignmentPropertiesArgs>? = null,
    public val resourceGroupName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.guestconfiguration.GuestConfigurationHCRPAssignmentArgs> {
    override fun toJava(): com.pulumi.azurenative.guestconfiguration.GuestConfigurationHCRPAssignmentArgs =
        com.pulumi.azurenative.guestconfiguration.GuestConfigurationHCRPAssignmentArgs.builder()
            .guestConfigurationAssignmentName(guestConfigurationAssignmentName?.applyValue({ args0 -> args0 }))
            .location(location?.applyValue({ args0 -> args0 }))
            .machineName(machineName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GuestConfigurationHCRPAssignmentArgs].
 */
@PulumiTagMarker
public class GuestConfigurationHCRPAssignmentArgsBuilder internal constructor() {
    private var guestConfigurationAssignmentName: Output<String>? = null

    private var location: Output<String>? = null

    private var machineName: Output<String>? = null

    private var name: Output<String>? = null

    private var properties: Output<GuestConfigurationAssignmentPropertiesArgs>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value Name of the guest configuration assignment.
     */
    @JvmName("pxgjscngkiclgopx")
    public suspend fun guestConfigurationAssignmentName(`value`: Output<String>) {
        this.guestConfigurationAssignmentName = value
    }

    /**
     * @param value Region where the VM is located.
     */
    @JvmName("ekwwufopebqtyoyn")
    public suspend fun location(`value`: Output<String>) {
        this.location = value
    }

    /**
     * @param value The name of the ARC machine.
     */
    @JvmName("vflfpmihhrtcbbgn")
    public suspend fun machineName(`value`: Output<String>) {
        this.machineName = value
    }

    /**
     * @param value Name of the guest configuration assignment.
     */
    @JvmName("pgkkyndmcdnlfgpk")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Properties of the Guest configuration assignment.
     */
    @JvmName("rflcnbpthfwhmktn")
    public suspend fun properties(`value`: Output<GuestConfigurationAssignmentPropertiesArgs>) {
        this.properties = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("dkmvuloasuvedhgg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value Name of the guest configuration assignment.
     */
    @JvmName("obraixhjntjiqreh")
    public suspend fun guestConfigurationAssignmentName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.guestConfigurationAssignmentName = mapped
    }

    /**
     * @param value Region where the VM is located.
     */
    @JvmName("ityrdhapbaculryo")
    public suspend fun location(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.location = mapped
    }

    /**
     * @param value The name of the ARC machine.
     */
    @JvmName("iyaimvxttfomeggs")
    public suspend fun machineName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.machineName = mapped
    }

    /**
     * @param value Name of the guest configuration assignment.
     */
    @JvmName("phrumqmnieccdgen")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Properties of the Guest configuration assignment.
     */
    @JvmName("dnslakjsshxjutlw")
    public suspend fun properties(`value`: GuestConfigurationAssignmentPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param argument Properties of the Guest configuration assignment.
     */
    @JvmName("bipqnyxgtgcseota")
    public suspend fun properties(argument: suspend GuestConfigurationAssignmentPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = GuestConfigurationAssignmentPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.properties = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("faieuidntjwohbbe")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): GuestConfigurationHCRPAssignmentArgs = GuestConfigurationHCRPAssignmentArgs(
        guestConfigurationAssignmentName = guestConfigurationAssignmentName,
        location = location,
        machineName = machineName,
        name = name,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
