@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin

import com.pulumi.azurenative.guestconfiguration.GuestconfigurationFunctions.getGuestConfigurationAssignmentPlain
import com.pulumi.azurenative.guestconfiguration.GuestconfigurationFunctions.getGuestConfigurationAssignmentsVMSSPlain
import com.pulumi.azurenative.guestconfiguration.GuestconfigurationFunctions.getGuestConfigurationConnectedVMwarevSphereAssignmentPlain
import com.pulumi.azurenative.guestconfiguration.GuestconfigurationFunctions.getGuestConfigurationHCRPAssignmentPlain
import com.pulumi.azurenative.guestconfiguration.kotlin.inputs.GetGuestConfigurationAssignmentPlainArgs
import com.pulumi.azurenative.guestconfiguration.kotlin.inputs.GetGuestConfigurationAssignmentPlainArgsBuilder
import com.pulumi.azurenative.guestconfiguration.kotlin.inputs.GetGuestConfigurationAssignmentsVMSSPlainArgs
import com.pulumi.azurenative.guestconfiguration.kotlin.inputs.GetGuestConfigurationAssignmentsVMSSPlainArgsBuilder
import com.pulumi.azurenative.guestconfiguration.kotlin.inputs.GetGuestConfigurationConnectedVMwarevSphereAssignmentPlainArgs
import com.pulumi.azurenative.guestconfiguration.kotlin.inputs.GetGuestConfigurationConnectedVMwarevSphereAssignmentPlainArgsBuilder
import com.pulumi.azurenative.guestconfiguration.kotlin.inputs.GetGuestConfigurationHCRPAssignmentPlainArgs
import com.pulumi.azurenative.guestconfiguration.kotlin.inputs.GetGuestConfigurationHCRPAssignmentPlainArgsBuilder
import com.pulumi.azurenative.guestconfiguration.kotlin.outputs.GetGuestConfigurationAssignmentResult
import com.pulumi.azurenative.guestconfiguration.kotlin.outputs.GetGuestConfigurationAssignmentsVMSSResult
import com.pulumi.azurenative.guestconfiguration.kotlin.outputs.GetGuestConfigurationConnectedVMwarevSphereAssignmentResult
import com.pulumi.azurenative.guestconfiguration.kotlin.outputs.GetGuestConfigurationHCRPAssignmentResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.guestconfiguration.kotlin.outputs.GetGuestConfigurationAssignmentResult.Companion.toKotlin as getGuestConfigurationAssignmentResultToKotlin
import com.pulumi.azurenative.guestconfiguration.kotlin.outputs.GetGuestConfigurationAssignmentsVMSSResult.Companion.toKotlin as getGuestConfigurationAssignmentsVMSSResultToKotlin
import com.pulumi.azurenative.guestconfiguration.kotlin.outputs.GetGuestConfigurationConnectedVMwarevSphereAssignmentResult.Companion.toKotlin as getGuestConfigurationConnectedVMwarevSphereAssignmentResultToKotlin
import com.pulumi.azurenative.guestconfiguration.kotlin.outputs.GetGuestConfigurationHCRPAssignmentResult.Companion.toKotlin as getGuestConfigurationHCRPAssignmentResultToKotlin

public object GuestconfigurationFunctions {
    /**
     * Get information about a guest configuration assignment
     * Azure REST API version: 2022-01-25.
     * @param argument null
     * @return Guest configuration assignment is an association between a machine and guest configuration.
     */
    public suspend fun getGuestConfigurationAssignment(argument: GetGuestConfigurationAssignmentPlainArgs): GetGuestConfigurationAssignmentResult =
        getGuestConfigurationAssignmentResultToKotlin(getGuestConfigurationAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getGuestConfigurationAssignment].
     * @param guestConfigurationAssignmentName The guest configuration assignment name.
     * @param resourceGroupName The resource group name.
     * @param vmName The name of the virtual machine.
     * @return Guest configuration assignment is an association between a machine and guest configuration.
     */
    public suspend fun getGuestConfigurationAssignment(
        guestConfigurationAssignmentName: String,
        resourceGroupName: String,
        vmName: String,
    ): GetGuestConfigurationAssignmentResult {
        val argument = GetGuestConfigurationAssignmentPlainArgs(
            guestConfigurationAssignmentName = guestConfigurationAssignmentName,
            resourceGroupName = resourceGroupName,
            vmName = vmName,
        )
        return getGuestConfigurationAssignmentResultToKotlin(getGuestConfigurationAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getGuestConfigurationAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;guestconfiguration&#46;kotlin&#46;inputs&#46;GetGuestConfigurationAssignmentPlainArgs].
     * @return Guest configuration assignment is an association between a machine and guest configuration.
     */
    public suspend fun getGuestConfigurationAssignment(argument: suspend GetGuestConfigurationAssignmentPlainArgsBuilder.() -> Unit): GetGuestConfigurationAssignmentResult {
        val builder = GetGuestConfigurationAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGuestConfigurationAssignmentResultToKotlin(getGuestConfigurationAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information about a guest configuration assignment for VMSS
     * Azure REST API version: 2022-01-25.
     * @param argument null
     * @return Guest configuration assignment is an association between a machine and guest configuration.
     */
    public suspend fun getGuestConfigurationAssignmentsVMSS(argument: GetGuestConfigurationAssignmentsVMSSPlainArgs): GetGuestConfigurationAssignmentsVMSSResult =
        getGuestConfigurationAssignmentsVMSSResultToKotlin(getGuestConfigurationAssignmentsVMSSPlain(argument.toJava()).await())

    /**
     * @see [getGuestConfigurationAssignmentsVMSS].
     * @param name The guest configuration assignment name.
     * @param resourceGroupName The resource group name.
     * @param vmssName The name of the virtual machine scale set.
     * @return Guest configuration assignment is an association between a machine and guest configuration.
     */
    public suspend fun getGuestConfigurationAssignmentsVMSS(
        name: String,
        resourceGroupName: String,
        vmssName: String,
    ): GetGuestConfigurationAssignmentsVMSSResult {
        val argument = GetGuestConfigurationAssignmentsVMSSPlainArgs(
            name = name,
            resourceGroupName = resourceGroupName,
            vmssName = vmssName,
        )
        return getGuestConfigurationAssignmentsVMSSResultToKotlin(getGuestConfigurationAssignmentsVMSSPlain(argument.toJava()).await())
    }

    /**
     * @see [getGuestConfigurationAssignmentsVMSS].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;guestconfiguration&#46;kotlin&#46;inputs&#46;GetGuestConfigurationAssignmentsVMSSPlainArgs].
     * @return Guest configuration assignment is an association between a machine and guest configuration.
     */
    public suspend fun getGuestConfigurationAssignmentsVMSS(argument: suspend GetGuestConfigurationAssignmentsVMSSPlainArgsBuilder.() -> Unit): GetGuestConfigurationAssignmentsVMSSResult {
        val builder = GetGuestConfigurationAssignmentsVMSSPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGuestConfigurationAssignmentsVMSSResultToKotlin(getGuestConfigurationAssignmentsVMSSPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information about a guest configuration assignment
     * Azure REST API version: 2022-01-25.
     * @param argument null
     * @return Guest configuration assignment is an association between a machine and guest configuration.
     */
    public suspend fun getGuestConfigurationConnectedVMwarevSphereAssignment(argument: GetGuestConfigurationConnectedVMwarevSphereAssignmentPlainArgs): GetGuestConfigurationConnectedVMwarevSphereAssignmentResult =
        getGuestConfigurationConnectedVMwarevSphereAssignmentResultToKotlin(getGuestConfigurationConnectedVMwarevSphereAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getGuestConfigurationConnectedVMwarevSphereAssignment].
     * @param guestConfigurationAssignmentName The guest configuration assignment name.
     * @param resourceGroupName The resource group name.
     * @param vmName The name of the virtual machine.
     * @return Guest configuration assignment is an association between a machine and guest configuration.
     */
    public suspend fun getGuestConfigurationConnectedVMwarevSphereAssignment(
        guestConfigurationAssignmentName: String,
        resourceGroupName: String,
        vmName: String,
    ): GetGuestConfigurationConnectedVMwarevSphereAssignmentResult {
        val argument = GetGuestConfigurationConnectedVMwarevSphereAssignmentPlainArgs(
            guestConfigurationAssignmentName = guestConfigurationAssignmentName,
            resourceGroupName = resourceGroupName,
            vmName = vmName,
        )
        return getGuestConfigurationConnectedVMwarevSphereAssignmentResultToKotlin(getGuestConfigurationConnectedVMwarevSphereAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getGuestConfigurationConnectedVMwarevSphereAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;guestconfiguration&#46;kotlin&#46;inputs&#46;GetGuestConfigurationConnectedVMwarevSphereAssignmentPlainArgs].
     * @return Guest configuration assignment is an association between a machine and guest configuration.
     */
    public suspend fun getGuestConfigurationConnectedVMwarevSphereAssignment(argument: suspend GetGuestConfigurationConnectedVMwarevSphereAssignmentPlainArgsBuilder.() -> Unit): GetGuestConfigurationConnectedVMwarevSphereAssignmentResult {
        val builder = GetGuestConfigurationConnectedVMwarevSphereAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGuestConfigurationConnectedVMwarevSphereAssignmentResultToKotlin(getGuestConfigurationConnectedVMwarevSphereAssignmentPlain(builtArgument.toJava()).await())
    }

    /**
     * Get information about a guest configuration assignment
     * Azure REST API version: 2022-01-25.
     * @param argument null
     * @return Guest configuration assignment is an association between a machine and guest configuration.
     */
    public suspend fun getGuestConfigurationHCRPAssignment(argument: GetGuestConfigurationHCRPAssignmentPlainArgs): GetGuestConfigurationHCRPAssignmentResult =
        getGuestConfigurationHCRPAssignmentResultToKotlin(getGuestConfigurationHCRPAssignmentPlain(argument.toJava()).await())

    /**
     * @see [getGuestConfigurationHCRPAssignment].
     * @param guestConfigurationAssignmentName The guest configuration assignment name.
     * @param machineName The name of the ARC machine.
     * @param resourceGroupName The resource group name.
     * @return Guest configuration assignment is an association between a machine and guest configuration.
     */
    public suspend fun getGuestConfigurationHCRPAssignment(
        guestConfigurationAssignmentName: String,
        machineName: String,
        resourceGroupName: String,
    ): GetGuestConfigurationHCRPAssignmentResult {
        val argument = GetGuestConfigurationHCRPAssignmentPlainArgs(
            guestConfigurationAssignmentName = guestConfigurationAssignmentName,
            machineName = machineName,
            resourceGroupName = resourceGroupName,
        )
        return getGuestConfigurationHCRPAssignmentResultToKotlin(getGuestConfigurationHCRPAssignmentPlain(argument.toJava()).await())
    }

    /**
     * @see [getGuestConfigurationHCRPAssignment].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;guestconfiguration&#46;kotlin&#46;inputs&#46;GetGuestConfigurationHCRPAssignmentPlainArgs].
     * @return Guest configuration assignment is an association between a machine and guest configuration.
     */
    public suspend fun getGuestConfigurationHCRPAssignment(argument: suspend GetGuestConfigurationHCRPAssignmentPlainArgsBuilder.() -> Unit): GetGuestConfigurationHCRPAssignmentResult {
        val builder = GetGuestConfigurationHCRPAssignmentPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGuestConfigurationHCRPAssignmentResultToKotlin(getGuestConfigurationHCRPAssignmentPlain(builtArgument.toJava()).await())
    }
}
