@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Specifies the assignment type and execution of the configuration. Possible values are Audit, DeployAndAutoCorrect, ApplyAndAutoCorrect and ApplyAndMonitor.
 */
public enum class AssignmentType(
    public val javaValue: com.pulumi.azurenative.guestconfiguration.enums.AssignmentType,
) : ConvertibleToJava<com.pulumi.azurenative.guestconfiguration.enums.AssignmentType> {
    Audit(com.pulumi.azurenative.guestconfiguration.enums.AssignmentType.Audit),
    DeployAndAutoCorrect(com.pulumi.azurenative.guestconfiguration.enums.AssignmentType.DeployAndAutoCorrect),
    ApplyAndAutoCorrect(com.pulumi.azurenative.guestconfiguration.enums.AssignmentType.ApplyAndAutoCorrect),
    ApplyAndMonitor(com.pulumi.azurenative.guestconfiguration.enums.AssignmentType.ApplyAndMonitor),
    ;

    override fun toJava(): com.pulumi.azurenative.guestconfiguration.enums.AssignmentType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.guestconfiguration.enums.AssignmentType): AssignmentType = AssignmentType.values().first { it.javaValue == javaType }
    }
}
