@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin.inputs

import com.pulumi.azurenative.guestconfiguration.inputs.GetGuestConfigurationAssignmentsVMSSPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The guest configuration assignment name.
 * @property resourceGroupName The resource group name.
 * @property vmssName The name of the virtual machine scale set.
 */
public data class GetGuestConfigurationAssignmentsVMSSPlainArgs(
    public val name: String,
    public val resourceGroupName: String,
    public val vmssName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.guestconfiguration.inputs.GetGuestConfigurationAssignmentsVMSSPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.guestconfiguration.inputs.GetGuestConfigurationAssignmentsVMSSPlainArgs =
        com.pulumi.azurenative.guestconfiguration.inputs.GetGuestConfigurationAssignmentsVMSSPlainArgs.builder()
            .name(name.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 }))
            .vmssName(vmssName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGuestConfigurationAssignmentsVMSSPlainArgs].
 */
@PulumiTagMarker
public class GetGuestConfigurationAssignmentsVMSSPlainArgsBuilder internal constructor() {
    private var name: String? = null

    private var resourceGroupName: String? = null

    private var vmssName: String? = null

    /**
     * @param value The guest configuration assignment name.
     */
    @JvmName("twkulqmwlwdfsmyw")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("jjchnvoltriagoes")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The name of the virtual machine scale set.
     */
    @JvmName("popdlbmgfukgsafk")
    public suspend fun vmssName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.vmssName = mapped
    }

    internal fun build(): GetGuestConfigurationAssignmentsVMSSPlainArgs =
        GetGuestConfigurationAssignmentsVMSSPlainArgs(
            name = name ?: throw PulumiNullFieldException("name"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
            vmssName = vmssName ?: throw PulumiNullFieldException("vmssName"),
        )
}
