@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin.inputs

import com.pulumi.azurenative.guestconfiguration.inputs.GetGuestConfigurationHCRPAssignmentPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property guestConfigurationAssignmentName The guest configuration assignment name.
 * @property machineName The name of the ARC machine.
 * @property resourceGroupName The resource group name.
 */
public data class GetGuestConfigurationHCRPAssignmentPlainArgs(
    public val guestConfigurationAssignmentName: String,
    public val machineName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.guestconfiguration.inputs.GetGuestConfigurationHCRPAssignmentPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.guestconfiguration.inputs.GetGuestConfigurationHCRPAssignmentPlainArgs =
        com.pulumi.azurenative.guestconfiguration.inputs.GetGuestConfigurationHCRPAssignmentPlainArgs.builder()
            .guestConfigurationAssignmentName(guestConfigurationAssignmentName.let({ args0 -> args0 }))
            .machineName(machineName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGuestConfigurationHCRPAssignmentPlainArgs].
 */
@PulumiTagMarker
public class GetGuestConfigurationHCRPAssignmentPlainArgsBuilder internal constructor() {
    private var guestConfigurationAssignmentName: String? = null

    private var machineName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The guest configuration assignment name.
     */
    @JvmName("kvgbptoxiqnpqygr")
    public suspend fun guestConfigurationAssignmentName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.guestConfigurationAssignmentName = mapped
    }

    /**
     * @param value The name of the ARC machine.
     */
    @JvmName("gpdwkbiwqptlnwkj")
    public suspend fun machineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.machineName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("fbrlyofejmdrdbes")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetGuestConfigurationHCRPAssignmentPlainArgs =
        GetGuestConfigurationHCRPAssignmentPlainArgs(
            guestConfigurationAssignmentName = guestConfigurationAssignmentName ?: throw
                PulumiNullFieldException("guestConfigurationAssignmentName"),
            machineName = machineName ?: throw PulumiNullFieldException("machineName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
