@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information about the guest configuration assignment.
 * @property configuration Information about the configuration.
 * @property name Name of the guest configuration assignment.
 */
public data class AssignmentInfoResponse(
    public val configuration: ConfigurationInfoResponse? = null,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.guestconfiguration.outputs.AssignmentInfoResponse): AssignmentInfoResponse = AssignmentInfoResponse(
            configuration = javaType.configuration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.guestconfiguration.kotlin.outputs.ConfigurationInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
        )
    }
}
