@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property assignment Configuration details of the guest configuration assignment.
 * @property complianceStatus A value indicating compliance status of the machine for the assigned guest configuration.
 * @property endTime End date and time of the guest configuration assignment compliance status check.
 * @property id ARM resource id of the report for the guest configuration assignment.
 * @property operationType Type of report, Consistency or Initial
 * @property reportId GUID that identifies the guest configuration assignment report under a subscription, resource group.
 * @property resources The list of resources for which guest configuration assignment compliance is checked.
 * @property startTime Start date and time of the guest configuration assignment compliance status check.
 * @property vm Information about the VM.
 */
public data class AssignmentReportResponse(
    public val assignment: AssignmentInfoResponse? = null,
    public val complianceStatus: String,
    public val endTime: String,
    public val id: String,
    public val operationType: String,
    public val reportId: String,
    public val resources: List<AssignmentReportResourceResponse>? = null,
    public val startTime: String,
    public val vm: VMInfoResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.guestconfiguration.outputs.AssignmentReportResponse): AssignmentReportResponse = AssignmentReportResponse(
            assignment = javaType.assignment().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.guestconfiguration.kotlin.outputs.AssignmentInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            complianceStatus = javaType.complianceStatus(),
            endTime = javaType.endTime(),
            id = javaType.id(),
            operationType = javaType.operationType(),
            reportId = javaType.reportId(),
            resources = javaType.resources().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.guestconfiguration.kotlin.outputs.AssignmentReportResourceResponse.Companion.toKotlin(args0)
                })
            }),
            startTime = javaType.startTime(),
            vm = javaType.vm().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.guestconfiguration.kotlin.outputs.VMInfoResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
