@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Represents a configuration parameter.
 * @property name Name of the configuration parameter.
 * @property value Value of the configuration parameter.
 */
public data class ConfigurationParameterResponse(
    public val name: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.guestconfiguration.outputs.ConfigurationParameterResponse): ConfigurationParameterResponse = ConfigurationParameterResponse(
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
        )
    }
}
