@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Guest configuration assignment properties.
 * @property assignmentHash Combined hash of the configuration package and parameters.
 * @property complianceStatus A value indicating compliance status of the machine for the assigned guest configuration.
 * @property context The source which initiated the guest configuration assignment. Ex: Azure Policy
 * @property guestConfiguration The guest configuration to assign.
 * @property lastComplianceStatusChecked Date and time when last compliance status was checked.
 * @property latestAssignmentReport Last reported guest configuration assignment report.
 * @property latestReportId Id of the latest report for the guest configuration assignment.
 * @property parameterHash parameter hash for the guest configuration assignment.
 * @property provisioningState The provisioning state, which only appears in the response.
 * @property resourceType Type of the resource - VMSS / VM
 * @property targetResourceId VM resource Id.
 * @property vmssVMList The list of VM Compliance data for VMSS
 */
public data class GuestConfigurationAssignmentPropertiesResponse(
    public val assignmentHash: String,
    public val complianceStatus: String,
    public val context: String? = null,
    public val guestConfiguration: GuestConfigurationNavigationResponse? = null,
    public val lastComplianceStatusChecked: String,
    public val latestAssignmentReport: AssignmentReportResponse? = null,
    public val latestReportId: String,
    public val parameterHash: String,
    public val provisioningState: String,
    public val resourceType: String,
    public val targetResourceId: String,
    public val vmssVMList: List<VMSSVMInfoResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.guestconfiguration.outputs.GuestConfigurationAssignmentPropertiesResponse): GuestConfigurationAssignmentPropertiesResponse =
            GuestConfigurationAssignmentPropertiesResponse(
                assignmentHash = javaType.assignmentHash(),
                complianceStatus = javaType.complianceStatus(),
                context = javaType.context().map({ args0 -> args0 }).orElse(null),
                guestConfiguration = javaType.guestConfiguration().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.guestconfiguration.kotlin.outputs.GuestConfigurationNavigationResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                lastComplianceStatusChecked = javaType.lastComplianceStatusChecked(),
                latestAssignmentReport = javaType.latestAssignmentReport().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.guestconfiguration.kotlin.outputs.AssignmentReportResponse.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                latestReportId = javaType.latestReportId(),
                parameterHash = javaType.parameterHash(),
                provisioningState = javaType.provisioningState(),
                resourceType = javaType.resourceType(),
                targetResourceId = javaType.targetResourceId(),
                vmssVMList = javaType.vmssVMList().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.guestconfiguration.kotlin.outputs.VMSSVMInfoResponse.Companion.toKotlin(args0)
                    })
                }),
            )
    }
}
