@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * Guest configuration is an artifact that encapsulates DSC configuration and its dependencies. The artifact is a zip file containing DSC configuration (as MOF) and dependent resources and other dependencies like modules.
 * @property assignmentSource Specifies the origin of the configuration.
 * @property assignmentType Specifies the assignment type and execution of the configuration. Possible values are Audit, DeployAndAutoCorrect, ApplyAndAutoCorrect and ApplyAndMonitor.
 * @property configurationParameter The configuration parameters for the guest configuration.
 * @property configurationProtectedParameter The protected configuration parameters for the guest configuration.
 * @property configurationSetting The configuration setting for the guest configuration.
 * @property contentHash Combined hash of the guest configuration package and configuration parameters.
 * @property contentType Specifies the content type of the configuration. Possible values could be Builtin or Custom.
 * @property contentUri Uri of the storage where guest configuration package is uploaded.
 * @property kind Kind of the guest configuration. For example:DSC
 * @property name Name of the guest configuration.
 * @property version Version of the guest configuration.
 */
public data class GuestConfigurationNavigationResponse(
    public val assignmentSource: String,
    public val assignmentType: String? = null,
    public val configurationParameter: List<ConfigurationParameterResponse>? = null,
    public val configurationProtectedParameter: List<ConfigurationParameterResponse>? = null,
    public val configurationSetting: ConfigurationSettingResponse,
    public val contentHash: String? = null,
    public val contentType: String,
    public val contentUri: String? = null,
    public val kind: String? = null,
    public val name: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.guestconfiguration.outputs.GuestConfigurationNavigationResponse): GuestConfigurationNavigationResponse = GuestConfigurationNavigationResponse(
            assignmentSource = javaType.assignmentSource(),
            assignmentType = javaType.assignmentType().map({ args0 -> args0 }).orElse(null),
            configurationParameter = javaType.configurationParameter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.guestconfiguration.kotlin.outputs.ConfigurationParameterResponse.Companion.toKotlin(args0)
                })
            }),
            configurationProtectedParameter = javaType.configurationProtectedParameter().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.guestconfiguration.kotlin.outputs.ConfigurationParameterResponse.Companion.toKotlin(args0)
                })
            }),
            configurationSetting = javaType.configurationSetting().let({ args0 ->
                com.pulumi.azurenative.guestconfiguration.kotlin.outputs.ConfigurationSettingResponse.Companion.toKotlin(args0)
            }),
            contentHash = javaType.contentHash().map({ args0 -> args0 }).orElse(null),
            contentType = javaType.contentType(),
            contentUri = javaType.contentUri().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
