@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.guestconfiguration.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Information about the VM.
 * @property id Azure resource Id of the VM.
 * @property uuid UUID(Universally Unique Identifier) of the VM.
 */
public data class VMInfoResponse(
    public val id: String,
    public val uuid: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.guestconfiguration.outputs.VMInfoResponse): VMInfoResponse = VMInfoResponse(
            id = javaType.id(),
            uuid = javaType.uuid(),
        )
    }
}
