@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin

import com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmClusterPrivateEndpointConnectionArgs.builder
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs.PrivateLinkServiceConnectionStateArgs
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.inputs.PrivateLinkServiceConnectionStateArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The private endpoint connection resource.
 * Azure REST API version: 2022-08-31-preview.
 * Other available API versions: 2023-12-10-preview.
 * ## Example Usage
 * ### CloudHsmClusterPrivateEndpointConnection_Create_MaximumSet_Gen
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cloudHsmClusterPrivateEndpointConnection = new AzureNative.HardwareSecurityModules.CloudHsmClusterPrivateEndpointConnection("cloudHsmClusterPrivateEndpointConnection", new()
 *     {
 *         CloudHsmClusterName = "chsm1",
 *         PeConnectionName = "sample-pec",
 *         PrivateLinkServiceConnectionState = new AzureNative.HardwareSecurityModules.Inputs.PrivateLinkServiceConnectionStateArgs
 *         {
 *             Description = "My name is Joe and I'm approving this.",
 *             Status = AzureNative.HardwareSecurityModules.PrivateEndpointServiceConnectionStatus.Approved,
 *         },
 *         ResourceGroupName = "rgcloudhsm",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hardwaresecuritymodules/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hardwaresecuritymodules.NewCloudHsmClusterPrivateEndpointConnection(ctx, "cloudHsmClusterPrivateEndpointConnection", &hardwaresecuritymodules.CloudHsmClusterPrivateEndpointConnectionArgs{
 * 			CloudHsmClusterName: pulumi.String("chsm1"),
 * 			PeConnectionName:    pulumi.String("sample-pec"),
 * 			PrivateLinkServiceConnectionState: &hardwaresecuritymodules.PrivateLinkServiceConnectionStateArgs{
 * 				Description: pulumi.String("My name is Joe and I'm approving this."),
 * 				Status:      pulumi.String(hardwaresecuritymodules.PrivateEndpointServiceConnectionStatusApproved),
 * 			},
 * 			ResourceGroupName: pulumi.String("rgcloudhsm"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmClusterPrivateEndpointConnection;
 * import com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmClusterPrivateEndpointConnectionArgs;
 * import com.pulumi.azurenative.hardwaresecuritymodules.inputs.PrivateLinkServiceConnectionStateArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cloudHsmClusterPrivateEndpointConnection = new CloudHsmClusterPrivateEndpointConnection("cloudHsmClusterPrivateEndpointConnection", CloudHsmClusterPrivateEndpointConnectionArgs.builder()
 *             .cloudHsmClusterName("chsm1")
 *             .peConnectionName("sample-pec")
 *             .privateLinkServiceConnectionState(PrivateLinkServiceConnectionStateArgs.builder()
 *                 .description("My name is Joe and I'm approving this.")
 *                 .status("Approved")
 *                 .build())
 *             .resourceGroupName("rgcloudhsm")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hardwaresecuritymodules:CloudHsmClusterPrivateEndpointConnection sample-pec /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/cloudHsmClusters/{cloudHsmClusterName}/privateEndpointConnections/{peConnectionName}
 * ```
 * @property cloudHsmClusterName The name of the Cloud HSM Cluster within the specified resource group. Cloud HSM Cluster names must be between 3 and 24 characters in length.
 * @property peConnectionName Name of the private endpoint connection associated with the Cloud HSM Cluster.
 * @property privateLinkServiceConnectionState A collection of information about the state of the connection between service consumer and provider.
 * @property resourceGroupName The name of the resource group. The name is case insensitive.
 */
public data class CloudHsmClusterPrivateEndpointConnectionArgs(
    public val cloudHsmClusterName: Output<String>? = null,
    public val peConnectionName: Output<String>? = null,
    public val privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null,
    public val resourceGroupName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmClusterPrivateEndpointConnectionArgs> {
    override fun toJava(): com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmClusterPrivateEndpointConnectionArgs =
        com.pulumi.azurenative.hardwaresecuritymodules.CloudHsmClusterPrivateEndpointConnectionArgs.builder()
            .cloudHsmClusterName(cloudHsmClusterName?.applyValue({ args0 -> args0 }))
            .peConnectionName(peConnectionName?.applyValue({ args0 -> args0 }))
            .privateLinkServiceConnectionState(
                privateLinkServiceConnectionState?.applyValue({ args0 ->
                    args0.let({ args0 -> args0.toJava() })
                }),
            )
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CloudHsmClusterPrivateEndpointConnectionArgs].
 */
@PulumiTagMarker
public class CloudHsmClusterPrivateEndpointConnectionArgsBuilder internal constructor() {
    private var cloudHsmClusterName: Output<String>? = null

    private var peConnectionName: Output<String>? = null

    private var privateLinkServiceConnectionState: Output<PrivateLinkServiceConnectionStateArgs>? =
        null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The name of the Cloud HSM Cluster within the specified resource group. Cloud HSM Cluster names must be between 3 and 24 characters in length.
     */
    @JvmName("cghplyqimogywfib")
    public suspend fun cloudHsmClusterName(`value`: Output<String>) {
        this.cloudHsmClusterName = value
    }

    /**
     * @param value Name of the private endpoint connection associated with the Cloud HSM Cluster.
     */
    @JvmName("giwlowhryfmndskq")
    public suspend fun peConnectionName(`value`: Output<String>) {
        this.peConnectionName = value
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("gtkhumsrmwxpytsw")
    public suspend fun privateLinkServiceConnectionState(`value`: Output<PrivateLinkServiceConnectionStateArgs>) {
        this.privateLinkServiceConnectionState = value
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("dubvcdwmcwfoaorb")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The name of the Cloud HSM Cluster within the specified resource group. Cloud HSM Cluster names must be between 3 and 24 characters in length.
     */
    @JvmName("wcfkdejlpltwnoma")
    public suspend fun cloudHsmClusterName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.cloudHsmClusterName = mapped
    }

    /**
     * @param value Name of the private endpoint connection associated with the Cloud HSM Cluster.
     */
    @JvmName("deflmnqdylmghtan")
    public suspend fun peConnectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.peConnectionName = mapped
    }

    /**
     * @param value A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("fsywgvujhfevwnmt")
    public suspend fun privateLinkServiceConnectionState(`value`: PrivateLinkServiceConnectionStateArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param argument A collection of information about the state of the connection between service consumer and provider.
     */
    @JvmName("qjgdhkltxiwslbmb")
    public suspend fun privateLinkServiceConnectionState(argument: suspend PrivateLinkServiceConnectionStateArgsBuilder.() -> Unit) {
        val toBeMapped = PrivateLinkServiceConnectionStateArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.privateLinkServiceConnectionState = mapped
    }

    /**
     * @param value The name of the resource group. The name is case insensitive.
     */
    @JvmName("bcsuyuthgkflbhay")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): CloudHsmClusterPrivateEndpointConnectionArgs =
        CloudHsmClusterPrivateEndpointConnectionArgs(
            cloudHsmClusterName = cloudHsmClusterName,
            peConnectionName = peConnectionName,
            privateLinkServiceConnectionState = privateLinkServiceConnectionState,
            resourceGroupName = resourceGroupName,
        )
}
