@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin

import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.NetworkProfileResponse
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.SkuResponse
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin as networkProfileResponseToKotlin
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.SkuResponse.Companion.toKotlin as skuResponseToKotlin
import com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [DedicatedHsm].
 */
@PulumiTagMarker
public class DedicatedHsmResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DedicatedHsmArgs = DedicatedHsmArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DedicatedHsmArgsBuilder.() -> Unit) {
        val builder = DedicatedHsmArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DedicatedHsm {
        val builtJavaResource =
            com.pulumi.azurenative.hardwaresecuritymodules.DedicatedHsm(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DedicatedHsm(builtJavaResource)
    }
}

/**
 * Resource information with extended details.
 * Azure REST API version: 2021-11-30. Prior API version in Azure Native 1.x: 2018-10-31-preview.
 * ## Example Usage
 * ### Create a new or update an existing dedicated HSM
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dedicatedHsm = new AzureNative.HardwareSecurityModules.DedicatedHsm("dedicatedHsm", new()
 *     {
 *         Location = "westus",
 *         Name = "hsm1",
 *         NetworkProfile = new AzureNative.HardwareSecurityModules.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.HardwareSecurityModules.Inputs.NetworkInterfaceArgs
 *                 {
 *                     PrivateIpAddress = "1.0.0.1",
 *                 },
 *             },
 *             Subnet = new AzureNative.HardwareSecurityModules.Inputs.ApiEntityReferenceArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01",
 *             },
 *         },
 *         ResourceGroupName = "hsm-group",
 *         Sku = new AzureNative.HardwareSecurityModules.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.HardwareSecurityModules.SkuName.SafeNet_Luna_Network_HSM_A790,
 *         },
 *         StampId = "stamp01",
 *         Tags =
 *         {
 *             { "Dept", "hsm" },
 *             { "Environment", "dogfood" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hardwaresecuritymodules/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hardwaresecuritymodules.NewDedicatedHsm(ctx, "dedicatedHsm", &hardwaresecuritymodules.DedicatedHsmArgs{
 * 			Location: pulumi.String("westus"),
 * 			Name:     pulumi.String("hsm1"),
 * 			NetworkProfile: &hardwaresecuritymodules.NetworkProfileArgs{
 * 				NetworkInterfaces: hardwaresecuritymodules.NetworkInterfaceArray{
 * 					&hardwaresecuritymodules.NetworkInterfaceArgs{
 * 						PrivateIpAddress: pulumi.String("1.0.0.1"),
 * 					},
 * 				},
 * 				Subnet: &hardwaresecuritymodules.ApiEntityReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("hsm-group"),
 * 			Sku: &hardwaresecuritymodules.SkuArgs{
 * 				Name: pulumi.String(hardwaresecuritymodules.SkuName_SafeNet_Luna_Network_HSM_A790),
 * 			},
 * 			StampId: pulumi.String("stamp01"),
 * 			Tags: pulumi.StringMap{
 * 				"Dept":        pulumi.String("hsm"),
 * 				"Environment": pulumi.String("dogfood"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hardwaresecuritymodules.DedicatedHsm;
 * import com.pulumi.azurenative.hardwaresecuritymodules.DedicatedHsmArgs;
 * import com.pulumi.azurenative.hardwaresecuritymodules.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.hardwaresecuritymodules.inputs.ApiEntityReferenceArgs;
 * import com.pulumi.azurenative.hardwaresecuritymodules.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dedicatedHsm = new DedicatedHsm("dedicatedHsm", DedicatedHsmArgs.builder()
 *             .location("westus")
 *             .name("hsm1")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceArgs.builder()
 *                     .privateIpAddress("1.0.0.1")
 *                     .build())
 *                 .subnet(ApiEntityReferenceArgs.builder()
 *                     .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("hsm-group")
 *             .sku(SkuArgs.builder()
 *                 .name("SafeNet Luna Network HSM A790")
 *                 .build())
 *             .stampId("stamp01")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Dept", "hsm"),
 *                 Map.entry("Environment", "dogfood")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new or update an existing payment HSM
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dedicatedHsm = new AzureNative.HardwareSecurityModules.DedicatedHsm("dedicatedHsm", new()
 *     {
 *         Location = "westus",
 *         Name = "hsm1",
 *         NetworkProfile = new AzureNative.HardwareSecurityModules.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.HardwareSecurityModules.Inputs.NetworkInterfaceArgs
 *                 {
 *                     PrivateIpAddress = "1.0.0.1",
 *                 },
 *             },
 *             Subnet = new AzureNative.HardwareSecurityModules.Inputs.ApiEntityReferenceArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01",
 *             },
 *         },
 *         ResourceGroupName = "hsm-group",
 *         Sku = new AzureNative.HardwareSecurityModules.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.HardwareSecurityModules.SkuName.PayShield10K_LMK1_CPS60,
 *         },
 *         StampId = "stamp01",
 *         Tags =
 *         {
 *             { "Dept", "hsm" },
 *             { "Environment", "dogfood" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hardwaresecuritymodules/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hardwaresecuritymodules.NewDedicatedHsm(ctx, "dedicatedHsm", &hardwaresecuritymodules.DedicatedHsmArgs{
 * 			Location: pulumi.String("westus"),
 * 			Name:     pulumi.String("hsm1"),
 * 			NetworkProfile: &hardwaresecuritymodules.NetworkProfileArgs{
 * 				NetworkInterfaces: hardwaresecuritymodules.NetworkInterfaceArray{
 * 					&hardwaresecuritymodules.NetworkInterfaceArgs{
 * 						PrivateIpAddress: pulumi.String("1.0.0.1"),
 * 					},
 * 				},
 * 				Subnet: &hardwaresecuritymodules.ApiEntityReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("hsm-group"),
 * 			Sku: &hardwaresecuritymodules.SkuArgs{
 * 				Name: pulumi.String(hardwaresecuritymodules.SkuName_PayShield10K_LMK1_CPS60),
 * 			},
 * 			StampId: pulumi.String("stamp01"),
 * 			Tags: pulumi.StringMap{
 * 				"Dept":        pulumi.String("hsm"),
 * 				"Environment": pulumi.String("dogfood"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hardwaresecuritymodules.DedicatedHsm;
 * import com.pulumi.azurenative.hardwaresecuritymodules.DedicatedHsmArgs;
 * import com.pulumi.azurenative.hardwaresecuritymodules.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.hardwaresecuritymodules.inputs.ApiEntityReferenceArgs;
 * import com.pulumi.azurenative.hardwaresecuritymodules.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dedicatedHsm = new DedicatedHsm("dedicatedHsm", DedicatedHsmArgs.builder()
 *             .location("westus")
 *             .name("hsm1")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceArgs.builder()
 *                     .privateIpAddress("1.0.0.1")
 *                     .build())
 *                 .subnet(ApiEntityReferenceArgs.builder()
 *                     .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("hsm-group")
 *             .sku(SkuArgs.builder()
 *                 .name("payShield10K_LMK1_CPS60")
 *                 .build())
 *             .stampId("stamp01")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Dept", "hsm"),
 *                 Map.entry("Environment", "dogfood")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ### Create a new or update an existing payment HSM with management profile
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dedicatedHsm = new AzureNative.HardwareSecurityModules.DedicatedHsm("dedicatedHsm", new()
 *     {
 *         Location = "westus",
 *         ManagementNetworkProfile = new AzureNative.HardwareSecurityModules.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.HardwareSecurityModules.Inputs.NetworkInterfaceArgs
 *                 {
 *                     PrivateIpAddress = "1.0.0.2",
 *                 },
 *             },
 *             Subnet = new AzureNative.HardwareSecurityModules.Inputs.ApiEntityReferenceArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01",
 *             },
 *         },
 *         Name = "hsm1",
 *         NetworkProfile = new AzureNative.HardwareSecurityModules.Inputs.NetworkProfileArgs
 *         {
 *             NetworkInterfaces = new[]
 *             {
 *                 new AzureNative.HardwareSecurityModules.Inputs.NetworkInterfaceArgs
 *                 {
 *                     PrivateIpAddress = "1.0.0.1",
 *                 },
 *             },
 *             Subnet = new AzureNative.HardwareSecurityModules.Inputs.ApiEntityReferenceArgs
 *             {
 *                 Id = "/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01",
 *             },
 *         },
 *         ResourceGroupName = "hsm-group",
 *         Sku = new AzureNative.HardwareSecurityModules.Inputs.SkuArgs
 *         {
 *             Name = AzureNative.HardwareSecurityModules.SkuName.PayShield10K_LMK1_CPS60,
 *         },
 *         StampId = "stamp01",
 *         Tags =
 *         {
 *             { "Dept", "hsm" },
 *             { "Environment", "dogfood" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hardwaresecuritymodules/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hardwaresecuritymodules.NewDedicatedHsm(ctx, "dedicatedHsm", &hardwaresecuritymodules.DedicatedHsmArgs{
 * 			Location: pulumi.String("westus"),
 * 			ManagementNetworkProfile: &hardwaresecuritymodules.NetworkProfileArgs{
 * 				NetworkInterfaces: hardwaresecuritymodules.NetworkInterfaceArray{
 * 					&hardwaresecuritymodules.NetworkInterfaceArgs{
 * 						PrivateIpAddress: pulumi.String("1.0.0.2"),
 * 					},
 * 				},
 * 				Subnet: &hardwaresecuritymodules.ApiEntityReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01"),
 * 				},
 * 			},
 * 			Name: pulumi.String("hsm1"),
 * 			NetworkProfile: &hardwaresecuritymodules.NetworkProfileArgs{
 * 				NetworkInterfaces: hardwaresecuritymodules.NetworkInterfaceArray{
 * 					&hardwaresecuritymodules.NetworkInterfaceArgs{
 * 						PrivateIpAddress: pulumi.String("1.0.0.1"),
 * 					},
 * 				},
 * 				Subnet: &hardwaresecuritymodules.ApiEntityReferenceArgs{
 * 					Id: pulumi.String("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01"),
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("hsm-group"),
 * 			Sku: &hardwaresecuritymodules.SkuArgs{
 * 				Name: pulumi.String(hardwaresecuritymodules.SkuName_PayShield10K_LMK1_CPS60),
 * 			},
 * 			StampId: pulumi.String("stamp01"),
 * 			Tags: pulumi.StringMap{
 * 				"Dept":        pulumi.String("hsm"),
 * 				"Environment": pulumi.String("dogfood"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hardwaresecuritymodules.DedicatedHsm;
 * import com.pulumi.azurenative.hardwaresecuritymodules.DedicatedHsmArgs;
 * import com.pulumi.azurenative.hardwaresecuritymodules.inputs.NetworkProfileArgs;
 * import com.pulumi.azurenative.hardwaresecuritymodules.inputs.ApiEntityReferenceArgs;
 * import com.pulumi.azurenative.hardwaresecuritymodules.inputs.SkuArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dedicatedHsm = new DedicatedHsm("dedicatedHsm", DedicatedHsmArgs.builder()
 *             .location("westus")
 *             .managementNetworkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceArgs.builder()
 *                     .privateIpAddress("1.0.0.2")
 *                     .build())
 *                 .subnet(ApiEntityReferenceArgs.builder()
 *                     .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01")
 *                     .build())
 *                 .build())
 *             .name("hsm1")
 *             .networkProfile(NetworkProfileArgs.builder()
 *                 .networkInterfaces(NetworkInterfaceArgs.builder()
 *                     .privateIpAddress("1.0.0.1")
 *                     .build())
 *                 .subnet(ApiEntityReferenceArgs.builder()
 *                     .id("/subscriptions/00000000-0000-0000-0000-000000000000/resourceGroups/hsm-group/providers/Microsoft.Network/virtualNetworks/stamp01/subnets/stamp01")
 *                     .build())
 *                 .build())
 *             .resourceGroupName("hsm-group")
 *             .sku(SkuArgs.builder()
 *                 .name("payShield10K_LMK1_CPS60")
 *                 .build())
 *             .stampId("stamp01")
 *             .tags(Map.ofEntries(
 *                 Map.entry("Dept", "hsm"),
 *                 Map.entry("Environment", "dogfood")
 *             ))
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hardwaresecuritymodules:DedicatedHsm hsm1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HardwareSecurityModules/dedicatedHSMs/{name}
 * ```
 */
public class DedicatedHsm internal constructor(
    override val javaResource: com.pulumi.azurenative.hardwaresecuritymodules.DedicatedHsm,
) : KotlinCustomResource(javaResource, DedicatedHsmMapper) {
    /**
     * The supported Azure location where the dedicated HSM should be created.
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * Specifies the management network interfaces of the dedicated hsm.
     */
    public val managementNetworkProfile: Output<NetworkProfileResponse>?
        get() = javaResource.managementNetworkProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * The name of the dedicated HSM.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Specifies the network interfaces of the dedicated hsm.
     */
    public val networkProfile: Output<NetworkProfileResponse>?
        get() = javaResource.networkProfile().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> networkProfileResponseToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Provisioning state.
     */
    public val provisioningState: Output<String>
        get() = javaResource.provisioningState().applyValue({ args0 -> args0 })

    /**
     * SKU details
     */
    public val sku: Output<SkuResponse>
        get() = javaResource.sku().applyValue({ args0 ->
            args0.let({ args0 ->
                skuResponseToKotlin(args0)
            })
        })

    /**
     * This field will be used when RP does not support Availability zones.
     */
    public val stampId: Output<String>?
        get() = javaResource.stampId().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Resource Status Message.
     */
    public val statusMessage: Output<String>
        get() = javaResource.statusMessage().applyValue({ args0 -> args0 })

    /**
     * Metadata pertaining to creation and last modification of the resource
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The resource type of the dedicated HSM.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The Dedicated Hsm zones.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object DedicatedHsmMapper : ResourceMapper<DedicatedHsm> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hardwaresecuritymodules.DedicatedHsm::class == javaResource::class

    override fun map(javaResource: Resource): DedicatedHsm = DedicatedHsm(
        javaResource as
            com.pulumi.azurenative.hardwaresecuritymodules.DedicatedHsm,
    )
}

/**
 * @see [DedicatedHsm].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DedicatedHsm].
 */
public suspend fun dedicatedHsm(
    name: String,
    block: suspend DedicatedHsmResourceBuilder.() -> Unit,
): DedicatedHsm {
    val builder = DedicatedHsmResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DedicatedHsm].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dedicatedHsm(name: String): DedicatedHsm {
    val builder = DedicatedHsmResourceBuilder()
    builder.name(name)
    return builder.build()
}
