@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Indicates whether the connection has been Approved/Rejected/Removed by the owner of the service.
 */
public enum class PrivateEndpointServiceConnectionStatus(
    public val javaValue: com.pulumi.azurenative.hardwaresecuritymodules.enums.PrivateEndpointServiceConnectionStatus,
) :
    ConvertibleToJava<com.pulumi.azurenative.hardwaresecuritymodules.enums.PrivateEndpointServiceConnectionStatus> {
    Pending(com.pulumi.azurenative.hardwaresecuritymodules.enums.PrivateEndpointServiceConnectionStatus.Pending),
    Approved(com.pulumi.azurenative.hardwaresecuritymodules.enums.PrivateEndpointServiceConnectionStatus.Approved),
    Rejected(com.pulumi.azurenative.hardwaresecuritymodules.enums.PrivateEndpointServiceConnectionStatus.Rejected),
    ;

    override fun toJava(): com.pulumi.azurenative.hardwaresecuritymodules.enums.PrivateEndpointServiceConnectionStatus =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hardwaresecuritymodules.enums.PrivateEndpointServiceConnectionStatus): PrivateEndpointServiceConnectionStatus =
            PrivateEndpointServiceConnectionStatus.values().first { it.javaValue == javaType }
    }
}
