@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Cloud Hsm Cluster SKU information
 * @property capacity Sku capacity
 * @property family Sku family of the Cloud HSM Cluster
 * @property name Sku name of the Cloud HSM Cluster
 */
public data class CloudHsmClusterSkuResponse(
    public val capacity: Int? = null,
    public val family: String,
    public val name: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hardwaresecuritymodules.outputs.CloudHsmClusterSkuResponse): CloudHsmClusterSkuResponse = CloudHsmClusterSkuResponse(
            capacity = javaType.capacity().map({ args0 -> args0 }).orElse(null),
            family = javaType.family(),
            name = javaType.name(),
        )
    }
}
