@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The Cloud HSM Properties
 * @property fqdn FQDN of the Cloud HSM
 * @property state The Cloud HSM State
 * @property stateMessage The Cloud HSM State message
 */
public data class CloudHsmPropertiesResponse(
    public val fqdn: String? = null,
    public val state: String? = null,
    public val stateMessage: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hardwaresecuritymodules.outputs.CloudHsmPropertiesResponse): CloudHsmPropertiesResponse = CloudHsmPropertiesResponse(
            fqdn = javaType.fqdn().map({ args0 -> args0 }).orElse(null),
            state = javaType.state().map({ args0 -> args0 }).orElse(null),
            stateMessage = javaType.stateMessage().map({ args0 -> args0 }).orElse(null),
        )
    }
}
