@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Resource information with extended details.
 * @property autoGeneratedDomainNameLabelScope The Cloud HSM Cluster's auto-generated Domain Name Label Scope
 * @property hsms An array of Cloud HSM Cluster's HSMs
 * @property id Fully qualified resource ID for the resource. E.g. "/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}"
 * @property location The geo-location where the resource lives
 * @property name The name of the resource
 * @property privateEndpointConnections List of private endpoint connection resources
 * @property provisioningState The Cloud HSM Cluster's provisioningState
 * @property publicNetworkAccess The Cloud HSM Cluster public network access
 * @property securityDomain Security domain properties information for Cloud HSM cluster
 * @property sku SKU details
 * @property systemData Azure Resource Manager metadata containing createdBy and modifiedBy information.
 * @property tags Resource tags.
 * @property type The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
 */
public data class GetCloudHsmClusterResult(
    public val autoGeneratedDomainNameLabelScope: String? = null,
    public val hsms: List<CloudHsmPropertiesResponse>? = null,
    public val id: String,
    public val location: String,
    public val name: String,
    public val privateEndpointConnections: List<PrivateEndpointConnectionResponse>? = null,
    public val provisioningState: String? = null,
    public val publicNetworkAccess: String? = null,
    public val securityDomain: CloudHsmClusterSecurityDomainPropertiesResponse? = null,
    public val sku: CloudHsmClusterSkuResponse? = null,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hardwaresecuritymodules.outputs.GetCloudHsmClusterResult): GetCloudHsmClusterResult = GetCloudHsmClusterResult(
            autoGeneratedDomainNameLabelScope = javaType.autoGeneratedDomainNameLabelScope().map({ args0 ->
                args0
            }).orElse(null),
            hsms = javaType.hsms().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.CloudHsmPropertiesResponse.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            location = javaType.location(),
            name = javaType.name(),
            privateEndpointConnections = javaType.privateEndpointConnections().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.PrivateEndpointConnectionResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState().map({ args0 -> args0 }).orElse(null),
            publicNetworkAccess = javaType.publicNetworkAccess().map({ args0 -> args0 }).orElse(null),
            securityDomain = javaType.securityDomain().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.CloudHsmClusterSecurityDomainPropertiesResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            sku = javaType.sku().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.CloudHsmClusterSkuResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
        )
    }
}
