@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Resource information with extended details.
 * @property id The Azure Resource Manager resource ID for the dedicated HSM.
 * @property location The supported Azure location where the dedicated HSM should be created.
 * @property managementNetworkProfile Specifies the management network interfaces of the dedicated hsm.
 * @property name The name of the dedicated HSM.
 * @property networkProfile Specifies the network interfaces of the dedicated hsm.
 * @property provisioningState Provisioning state.
 * @property sku SKU details
 * @property stampId This field will be used when RP does not support Availability zones.
 * @property statusMessage Resource Status Message.
 * @property systemData Metadata pertaining to creation and last modification of the resource
 * @property tags Resource tags
 * @property type The resource type of the dedicated HSM.
 * @property zones The Dedicated Hsm zones.
 */
public data class GetDedicatedHsmResult(
    public val id: String,
    public val location: String,
    public val managementNetworkProfile: NetworkProfileResponse? = null,
    public val name: String,
    public val networkProfile: NetworkProfileResponse? = null,
    public val provisioningState: String,
    public val sku: SkuResponse,
    public val stampId: String? = null,
    public val statusMessage: String,
    public val systemData: SystemDataResponse,
    public val tags: Map<String, String>? = null,
    public val type: String,
    public val zones: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hardwaresecuritymodules.outputs.GetDedicatedHsmResult): GetDedicatedHsmResult = GetDedicatedHsmResult(
            id = javaType.id(),
            location = javaType.location(),
            managementNetworkProfile = javaType.managementNetworkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            name = javaType.name(),
            networkProfile = javaType.networkProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.NetworkProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            sku = javaType.sku().let({ args0 ->
                com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.SkuResponse.Companion.toKotlin(args0)
            }),
            stampId = javaType.stampId().map({ args0 -> args0 }).orElse(null),
            statusMessage = javaType.statusMessage(),
            systemData = javaType.systemData().let({ args0 ->
                com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.SystemDataResponse.Companion.toKotlin(args0)
            }),
            tags = javaType.tags().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            type = javaType.type(),
            zones = javaType.zones().map({ args0 -> args0 }),
        )
    }
}
