@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 * The network profile definition.
 * @property networkInterfaces Specifies the list of resource Ids for the network interfaces associated with the dedicated HSM.
 * @property subnet Specifies the identifier of the subnet.
 */
public data class NetworkProfileResponse(
    public val networkInterfaces: List<NetworkInterfaceResponse>? = null,
    public val subnet: ApiEntityReferenceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hardwaresecuritymodules.outputs.NetworkProfileResponse): NetworkProfileResponse = NetworkProfileResponse(
            networkInterfaces = javaType.networkInterfaces().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.NetworkInterfaceResponse.Companion.toKotlin(args0)
                })
            }),
            subnet = javaType.subnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hardwaresecuritymodules.kotlin.outputs.ApiEntityReferenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
