@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin

import com.pulumi.azurenative.hdinsight.kotlin.outputs.ApplicationPropertiesResponse
import com.pulumi.azurenative.hdinsight.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.azurenative.hdinsight.kotlin.outputs.ApplicationPropertiesResponse.Companion.toKotlin as applicationPropertiesResponseToKotlin
import com.pulumi.azurenative.hdinsight.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Application].
 */
@PulumiTagMarker
public class ApplicationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ApplicationArgs = ApplicationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ApplicationArgsBuilder.() -> Unit) {
        val builder = ApplicationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Application {
        val builtJavaResource = com.pulumi.azurenative.hdinsight.Application(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Application(builtJavaResource)
    }
}

/**
 * The HDInsight cluster application
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2018-06-01-preview.
 * Other available API versions: 2023-04-15-preview, 2023-08-15-preview.
 * ## Example Usage
 * ### Create Application
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var application = new AzureNative.HDInsight.Application("application", new()
 *     {
 *         ApplicationName = "hue",
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ApplicationPropertiesArgs
 *         {
 *             ApplicationType = "CustomApplication",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D12_v2",
 *                         },
 *                         Name = "edgenode",
 *                         TargetInstanceCount = 1,
 *                     },
 *                 },
 *             },
 *             Errors = new() { },
 *             HttpsEndpoints = new[]
 *             {
 *                 new AzureNative.HDInsight.Inputs.ApplicationGetHttpsEndpointArgs
 *                 {
 *                     AccessModes = new[]
 *                     {
 *                         "WebPage",
 *                     },
 *                     DestinationPort = 20000,
 *                     SubDomainSuffix = "dss",
 *                 },
 *             },
 *             InstallScriptActions = new[]
 *             {
 *                 new AzureNative.HDInsight.Inputs.RuntimeScriptActionArgs
 *                 {
 *                     Name = "app-install-app1",
 *                     Parameters = "-version latest -port 20000",
 *                     Roles = new[]
 *                     {
 *                         "edgenode",
 *                     },
 *                     Uri = "https://.../install.sh",
 *                 },
 *             },
 *             UninstallScriptActions = new() { },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hdinsight.NewApplication(ctx, "application", &hdinsight.ApplicationArgs{
 * 			ApplicationName: pulumi.String("hue"),
 * 			ClusterName:     pulumi.String("cluster1"),
 * 			Properties: &hdinsight.ApplicationPropertiesArgs{
 * 				ApplicationType: pulumi.String("CustomApplication"),
 * 				ComputeProfile: &hdinsight.ComputeProfileArgs{
 * 					Roles: hdinsight.RoleArray{
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Standard_D12_v2"),
 * 							},
 * 							Name:                pulumi.String("edgenode"),
 * 							TargetInstanceCount: pulumi.Int(1),
 * 						},
 * 					},
 * 				},
 * 				Errors: hdinsight.ErrorsArray{},
 * 				HttpsEndpoints: hdinsight.ApplicationGetHttpsEndpointArray{
 * 					&hdinsight.ApplicationGetHttpsEndpointArgs{
 * 						AccessModes: pulumi.StringArray{
 * 							pulumi.String("WebPage"),
 * 						},
 * 						DestinationPort: pulumi.Int(20000),
 * 						SubDomainSuffix: pulumi.String("dss"),
 * 					},
 * 				},
 * 				InstallScriptActions: hdinsight.RuntimeScriptActionArray{
 * 					&hdinsight.RuntimeScriptActionArgs{
 * 						Name:       pulumi.String("app-install-app1"),
 * 						Parameters: pulumi.String("-version latest -port 20000"),
 * 						Roles: pulumi.StringArray{
 * 							pulumi.String("edgenode"),
 * 						},
 * 						Uri: pulumi.String("https://.../install.sh"),
 * 					},
 * 				},
 * 				UninstallScriptActions: hdinsight.RuntimeScriptActionArray{},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Application;
 * import com.pulumi.azurenative.hdinsight.ApplicationArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ApplicationPropertiesArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ComputeProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var application = new Application("application", ApplicationArgs.builder()
 *             .applicationName("hue")
 *             .clusterName("cluster1")
 *             .properties(ApplicationPropertiesArgs.builder()
 *                 .applicationType("CustomApplication")
 *                 .computeProfile(ComputeProfileArgs.builder()
 *                     .roles(RoleArgs.builder()
 *                         .hardwareProfile(HardwareProfileArgs.builder()
 *                             .vmSize("Standard_D12_v2")
 *                             .build())
 *                         .name("edgenode")
 *                         .targetInstanceCount(1)
 *                         .build())
 *                     .build())
 *                 .errors()
 *                 .httpsEndpoints(ApplicationGetHttpsEndpointArgs.builder()
 *                     .accessModes("WebPage")
 *                     .destinationPort(20000)
 *                     .subDomainSuffix("dss")
 *                     .build())
 *                 .installScriptActions(RuntimeScriptActionArgs.builder()
 *                     .name("app-install-app1")
 *                     .parameters("-version latest -port 20000")
 *                     .roles("edgenode")
 *                     .uri("https://.../install.sh")
 *                     .build())
 *                 .uninstallScriptActions()
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hdinsight:Application hue /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}/applications/{applicationName}
 * ```
 */
public class Application internal constructor(
    override val javaResource: com.pulumi.azurenative.hdinsight.Application,
) : KotlinCustomResource(javaResource, ApplicationMapper) {
    /**
     * The ETag for the application
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The properties of the application.
     */
    public val properties: Output<ApplicationPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                applicationPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * The tags for the application.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object ApplicationMapper : ResourceMapper<Application> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hdinsight.Application::class == javaResource::class

    override fun map(javaResource: Resource): Application = Application(
        javaResource as
            com.pulumi.azurenative.hdinsight.Application,
    )
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Application].
 */
public suspend fun application(name: String, block: suspend ApplicationResourceBuilder.() -> Unit): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Application].
 * @param name The _unique_ name of the resulting resource.
 */
public fun application(name: String): Application {
    val builder = ApplicationResourceBuilder()
    builder.name(name)
    return builder.build()
}
