@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin

import com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterGetPropertiesResponse
import com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterIdentityResponse
import com.pulumi.azurenative.hdinsight.kotlin.outputs.SystemDataResponse
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterGetPropertiesResponse.Companion.toKotlin as clusterGetPropertiesResponseToKotlin
import com.pulumi.azurenative.hdinsight.kotlin.outputs.ClusterIdentityResponse.Companion.toKotlin as clusterIdentityResponseToKotlin
import com.pulumi.azurenative.hdinsight.kotlin.outputs.SystemDataResponse.Companion.toKotlin as systemDataResponseToKotlin

/**
 * Builder for [Cluster].
 */
@PulumiTagMarker
public class ClusterResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ClusterArgs = ClusterArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ClusterArgsBuilder.() -> Unit) {
        val builder = ClusterArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Cluster {
        val builtJavaResource = com.pulumi.azurenative.hdinsight.Cluster(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Cluster(builtJavaResource)
    }
}

/**
 * The HDInsight cluster.
 * Azure REST API version: 2021-06-01. Prior API version in Azure Native 1.x: 2018-06-01-preview.
 * Other available API versions: 2023-04-15-preview, 2023-06-01-preview, 2023-08-15-preview, 2023-11-01-preview, 2024-05-01.
 * ## Example Usage
 * ### Create HDInsight cluster with Autoscale configuration
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 ComponentVersion =
 *                 {
 *                     { "Hadoop", "2.7" },
 *                 },
 *                 Configurations = new Dictionary<string, object?>
 *                 {
 *                     ["gateway"] = new Dictionary<string, object?>
 *                     {
 *                         ["restAuthCredential.isEnabled"] = true,
 *                         ["restAuthCredential.password"] = "**********",
 *                         ["restAuthCredential.username"] = "admin",
 *                     },
 *                 },
 *                 Kind = "hadoop",
 *             },
 *             ClusterVersion = "3.6",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         AutoscaleConfiguration = new AzureNative.HDInsight.Inputs.AutoscaleArgs
 *                         {
 *                             Recurrence = new AzureNative.HDInsight.Inputs.AutoscaleRecurrenceArgs
 *                             {
 *                                 Schedule = new[]
 *                                 {
 *                                     new AzureNative.HDInsight.Inputs.AutoscaleScheduleArgs
 *                                     {
 *                                         Days = new[]
 *                                         {
 *                                             AzureNative.HDInsight.DaysOfWeek.Monday,
 *                                             AzureNative.HDInsight.DaysOfWeek.Tuesday,
 *                                             AzureNative.HDInsight.DaysOfWeek.Wednesday,
 *                                             AzureNative.HDInsight.DaysOfWeek.Thursday,
 *                                             AzureNative.HDInsight.DaysOfWeek.Friday,
 *                                         },
 *                                         TimeAndCapacity = new AzureNative.HDInsight.Inputs.AutoscaleTimeAndCapacityArgs
 *                                         {
 *                                             MaxInstanceCount = 3,
 *                                             MinInstanceCount = 3,
 *                                             Time = "09:00",
 *                                         },
 *                                     },
 *                                     new AzureNative.HDInsight.Inputs.AutoscaleScheduleArgs
 *                                     {
 *                                         Days = new[]
 *                                         {
 *                                             AzureNative.HDInsight.DaysOfWeek.Monday,
 *                                             AzureNative.HDInsight.DaysOfWeek.Tuesday,
 *                                             AzureNative.HDInsight.DaysOfWeek.Wednesday,
 *                                             AzureNative.HDInsight.DaysOfWeek.Thursday,
 *                                             AzureNative.HDInsight.DaysOfWeek.Friday,
 *                                         },
 *                                         TimeAndCapacity = new AzureNative.HDInsight.Inputs.AutoscaleTimeAndCapacityArgs
 *                                         {
 *                                             MaxInstanceCount = 6,
 *                                             MinInstanceCount = 6,
 *                                             Time = "18:00",
 *                                         },
 *                                     },
 *                                     new AzureNative.HDInsight.Inputs.AutoscaleScheduleArgs
 *                                     {
 *                                         Days = new[]
 *                                         {
 *                                             AzureNative.HDInsight.DaysOfWeek.Saturday,
 *                                             AzureNative.HDInsight.DaysOfWeek.Sunday,
 *                                         },
 *                                         TimeAndCapacity = new AzureNative.HDInsight.Inputs.AutoscaleTimeAndCapacityArgs
 *                                         {
 *                                             MaxInstanceCount = 2,
 *                                             MinInstanceCount = 2,
 *                                             Time = "09:00",
 *                                         },
 *                                     },
 *                                     new AzureNative.HDInsight.Inputs.AutoscaleScheduleArgs
 *                                     {
 *                                         Days = new[]
 *                                         {
 *                                             AzureNative.HDInsight.DaysOfWeek.Saturday,
 *                                             AzureNative.HDInsight.DaysOfWeek.Sunday,
 *                                         },
 *                                         TimeAndCapacity = new AzureNative.HDInsight.Inputs.AutoscaleTimeAndCapacityArgs
 *                                         {
 *                                             MaxInstanceCount = 4,
 *                                             MinInstanceCount = 4,
 *                                             Time = "18:00",
 *                                         },
 *                                     },
 *                                 },
 *                                 TimeZone = "China Standard Time",
 *                             },
 *                         },
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D4_V2",
 *                         },
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         ScriptActions = new() { },
 *                         TargetInstanceCount = 4,
 *                     },
 *                 },
 *             },
 *             OsType = AzureNative.HDInsight.OSType.Linux,
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "hdinsight-autoscale-tes-2019-06-18t05-49-16-591z",
 *                         IsDefault = true,
 *                         Key = "storagekey",
 *                         Name = "mystorage.blob.core.windows.net",
 *                     },
 *                 },
 *             },
 *             Tier = AzureNative.HDInsight.Tier.Standard,
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * 			ClusterName: pulumi.String("cluster1"),
 * 			Properties: &hdinsight.ClusterCreatePropertiesArgs{
 * 				ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * 					ComponentVersion: pulumi.StringMap{
 * 						"Hadoop": pulumi.String("2.7"),
 * 					},
 * 					Configurations: pulumi.Any(map[string]interface{}{
 * 						"gateway": map[string]interface{}{
 * 							"restAuthCredential.isEnabled": true,
 * 							"restAuthCredential.password":  "**********",
 * 							"restAuthCredential.username":  "admin",
 * 						},
 * 					}),
 * 					Kind: pulumi.String("hadoop"),
 * 				},
 * 				ClusterVersion: pulumi.String("3.6"),
 * 				ComputeProfile: &hdinsight.ComputeProfileArgs{
 * 					Roles: hdinsight.RoleArray{
 * 						&hdinsight.RoleArgs{
 * 							AutoscaleConfiguration: &hdinsight.AutoscaleArgs{
 * 								Recurrence: &hdinsight.AutoscaleRecurrenceArgs{
 * 									Schedule: hdinsight.AutoscaleScheduleArray{
 * 										&hdinsight.AutoscaleScheduleArgs{
 * 											Days: pulumi.StringArray{
 * 												pulumi.String(hdinsight.DaysOfWeekMonday),
 * 												pulumi.String(hdinsight.DaysOfWeekTuesday),
 * 												pulumi.String(hdinsight.DaysOfWeekWednesday),
 * 												pulumi.String(hdinsight.DaysOfWeekThursday),
 * 												pulumi.String(hdinsight.DaysOfWeekFriday),
 * 											},
 * 											TimeAndCapacity: &hdinsight.AutoscaleTimeAndCapacityArgs{
 * 												MaxInstanceCount: pulumi.Int(3),
 * 												MinInstanceCount: pulumi.Int(3),
 * 												Time:             pulumi.String("09:00"),
 * 											},
 * 										},
 * 										&hdinsight.AutoscaleScheduleArgs{
 * 											Days: pulumi.StringArray{
 * 												pulumi.String(hdinsight.DaysOfWeekMonday),
 * 												pulumi.String(hdinsight.DaysOfWeekTuesday),
 * 												pulumi.String(hdinsight.DaysOfWeekWednesday),
 * 												pulumi.String(hdinsight.DaysOfWeekThursday),
 * 												pulumi.String(hdinsight.DaysOfWeekFriday),
 * 											},
 * 											TimeAndCapacity: &hdinsight.AutoscaleTimeAndCapacityArgs{
 * 												MaxInstanceCount: pulumi.Int(6),
 * 												MinInstanceCount: pulumi.Int(6),
 * 												Time:             pulumi.String("18:00"),
 * 											},
 * 										},
 * 										&hdinsight.AutoscaleScheduleArgs{
 * 											Days: pulumi.StringArray{
 * 												pulumi.String(hdinsight.DaysOfWeekSaturday),
 * 												pulumi.String(hdinsight.DaysOfWeekSunday),
 * 											},
 * 											TimeAndCapacity: &hdinsight.AutoscaleTimeAndCapacityArgs{
 * 												MaxInstanceCount: pulumi.Int(2),
 * 												MinInstanceCount: pulumi.Int(2),
 * 												Time:             pulumi.String("09:00"),
 * 											},
 * 										},
 * 										&hdinsight.AutoscaleScheduleArgs{
 * 											Days: pulumi.StringArray{
 * 												pulumi.String(hdinsight.DaysOfWeekSaturday),
 * 												pulumi.String(hdinsight.DaysOfWeekSunday),
 * 											},
 * 											TimeAndCapacity: &hdinsight.AutoscaleTimeAndCapacityArgs{
 * 												MaxInstanceCount: pulumi.Int(4),
 * 												MinInstanceCount: pulumi.Int(4),
 * 												Time:             pulumi.String("18:00"),
 * 											},
 * 										},
 * 									},
 * 									TimeZone: pulumi.String("China Standard Time"),
 * 								},
 * 							},
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Standard_D4_V2"),
 * 							},
 * 							Name: pulumi.String("workernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							ScriptActions:       hdinsight.ScriptActionArray{},
 * 							TargetInstanceCount: pulumi.Int(4),
 * 						},
 * 					},
 * 				},
 * 				OsType: pulumi.String(hdinsight.OSTypeLinux),
 * 				StorageProfile: &hdinsight.StorageProfileArgs{
 * 					Storageaccounts: hdinsight.StorageAccountArray{
 * 						&hdinsight.StorageAccountArgs{
 * 							Container: pulumi.String("hdinsight-autoscale-tes-2019-06-18t05-49-16-591z"),
 * 							IsDefault: pulumi.Bool(true),
 * 							Key:       pulumi.String("storagekey"),
 * 							Name:      pulumi.String("mystorage.blob.core.windows.net"),
 * 						},
 * 					},
 * 				},
 * 				Tier: pulumi.String(hdinsight.TierStandard),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterCreatePropertiesArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterDefinitionArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ComputeProfileArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.StorageProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(ClusterCreatePropertiesArgs.builder()
 *                 .clusterDefinition(ClusterDefinitionArgs.builder()
 *                     .componentVersion(Map.of("Hadoop", "2.7"))
 *                     .configurations(Map.of("gateway", Map.ofEntries(
 *                         Map.entry("restAuthCredential.isEnabled", true),
 *                         Map.entry("restAuthCredential.password", "**********"),
 *                         Map.entry("restAuthCredential.username", "admin")
 *                     )))
 *                     .kind("hadoop")
 *                     .build())
 *                 .clusterVersion("3.6")
 *                 .computeProfile(ComputeProfileArgs.builder()
 *                     .roles(RoleArgs.builder()
 *                         .autoscaleConfiguration(AutoscaleArgs.builder()
 *                             .recurrence(AutoscaleRecurrenceArgs.builder()
 *                                 .schedule(
 *                                     AutoscaleScheduleArgs.builder()
 *                                         .days(
 *                                             "Monday",
 *                                             "Tuesday",
 *                                             "Wednesday",
 *                                             "Thursday",
 *                                             "Friday")
 *                                         .timeAndCapacity(AutoscaleTimeAndCapacityArgs.builder()
 *                                             .maxInstanceCount(3)
 *                                             .minInstanceCount(3)
 *                                             .time("09:00")
 *                                             .build())
 *                                         .build(),
 *                                     AutoscaleScheduleArgs.builder()
 *                                         .days(
 *                                             "Monday",
 *                                             "Tuesday",
 *                                             "Wednesday",
 *                                             "Thursday",
 *                                             "Friday")
 *                                         .timeAndCapacity(AutoscaleTimeAndCapacityArgs.builder()
 *                                             .maxInstanceCount(6)
 *                                             .minInstanceCount(6)
 *                                             .time("18:00")
 *                                             .build())
 *                                         .build(),
 *                                     AutoscaleScheduleArgs.builder()
 *                                         .days(
 *                                             "Saturday",
 *                                             "Sunday")
 *                                         .timeAndCapacity(AutoscaleTimeAndCapacityArgs.builder()
 *                                             .maxInstanceCount(2)
 *                                             .minInstanceCount(2)
 *                                             .time("09:00")
 *                                             .build())
 *                                         .build(),
 *                                     AutoscaleScheduleArgs.builder()
 *                                         .days(
 *                                             "Saturday",
 *                                             "Sunday")
 *                                         .timeAndCapacity(AutoscaleTimeAndCapacityArgs.builder()
 *                                             .maxInstanceCount(4)
 *                                             .minInstanceCount(4)
 *                                             .time("18:00")
 *                                             .build())
 *                                         .build())
 *                                 .timeZone("China Standard Time")
 *                                 .build())
 *                             .build())
 *                         .hardwareProfile(HardwareProfileArgs.builder()
 *                             .vmSize("Standard_D4_V2")
 *                             .build())
 *                         .name("workernode")
 *                         .osProfile(OsProfileArgs.builder()
 *                             .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                 .password("**********")
 *                                 .username("sshuser")
 *                                 .build())
 *                             .build())
 *                         .scriptActions()
 *                         .targetInstanceCount(4)
 *                         .build())
 *                     .build())
 *                 .osType("Linux")
 *                 .storageProfile(StorageProfileArgs.builder()
 *                     .storageaccounts(StorageAccountArgs.builder()
 *                         .container("hdinsight-autoscale-tes-2019-06-18t05-49-16-591z")
 *                         .isDefault(true)
 *                         .key("storagekey")
 *                         .name("mystorage.blob.core.windows.net")
 *                         .build())
 *                     .build())
 *                 .tier("Standard")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Hadoop cluster with Azure Data Lake Storage Gen 2
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 Configurations = new Dictionary<string, object?>
 *                 {
 *                     ["gateway"] = new Dictionary<string, object?>
 *                     {
 *                         ["restAuthCredential.isEnabled"] = "true",
 *                         ["restAuthCredential.password"] = "**********",
 *                         ["restAuthCredential.username"] = "admin",
 *                     },
 *                 },
 *                 Kind = "Hadoop",
 *             },
 *             ClusterVersion = "3.6",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D3_V2",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D3_V2",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 4,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Small",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "zookeepernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                 },
 *             },
 *             OsType = AzureNative.HDInsight.OSType.Linux,
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         FileSystem = "default",
 *                         IsDefault = true,
 *                         Key = "storagekey",
 *                         Name = "mystorage.dfs.core.windows.net",
 *                     },
 *                 },
 *             },
 *             Tier = AzureNative.HDInsight.Tier.Standard,
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * 			ClusterName: pulumi.String("cluster1"),
 * 			Properties: &hdinsight.ClusterCreatePropertiesArgs{
 * 				ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * 					Configurations: pulumi.Any(map[string]interface{}{
 * 						"gateway": map[string]interface{}{
 * 							"restAuthCredential.isEnabled": "true",
 * 							"restAuthCredential.password":  "**********",
 * 							"restAuthCredential.username":  "admin",
 * 						},
 * 					}),
 * 					Kind: pulumi.String("Hadoop"),
 * 				},
 * 				ClusterVersion: pulumi.String("3.6"),
 * 				ComputeProfile: &hdinsight.ComputeProfileArgs{
 * 					Roles: hdinsight.RoleArray{
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Standard_D3_V2"),
 * 							},
 * 							MinInstanceCount: pulumi.Int(1),
 * 							Name:             pulumi.String("headnode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(2),
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Standard_D3_V2"),
 * 							},
 * 							MinInstanceCount: pulumi.Int(1),
 * 							Name:             pulumi.String("workernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(4),
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Small"),
 * 							},
 * 							MinInstanceCount: pulumi.Int(1),
 * 							Name:             pulumi.String("zookeepernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(3),
 * 						},
 * 					},
 * 				},
 * 				OsType: pulumi.String(hdinsight.OSTypeLinux),
 * 				StorageProfile: &hdinsight.StorageProfileArgs{
 * 					Storageaccounts: hdinsight.StorageAccountArray{
 * 						&hdinsight.StorageAccountArgs{
 * 							FileSystem: pulumi.String("default"),
 * 							IsDefault:  pulumi.Bool(true),
 * 							Key:        pulumi.String("storagekey"),
 * 							Name:       pulumi.String("mystorage.dfs.core.windows.net"),
 * 						},
 * 					},
 * 				},
 * 				Tier: pulumi.String(hdinsight.TierStandard),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("val1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterCreatePropertiesArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterDefinitionArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ComputeProfileArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.StorageProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(ClusterCreatePropertiesArgs.builder()
 *                 .clusterDefinition(ClusterDefinitionArgs.builder()
 *                     .configurations(Map.of("gateway", Map.ofEntries(
 *                         Map.entry("restAuthCredential.isEnabled", "true"),
 *                         Map.entry("restAuthCredential.password", "**********"),
 *                         Map.entry("restAuthCredential.username", "admin")
 *                     )))
 *                     .kind("Hadoop")
 *                     .build())
 *                 .clusterVersion("3.6")
 *                 .computeProfile(ComputeProfileArgs.builder()
 *                     .roles(
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Standard_D3_V2")
 *                                 .build())
 *                             .minInstanceCount(1)
 *                             .name("headnode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(2)
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Standard_D3_V2")
 *                                 .build())
 *                             .minInstanceCount(1)
 *                             .name("workernode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(4)
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Small")
 *                                 .build())
 *                             .minInstanceCount(1)
 *                             .name("zookeepernode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(3)
 *                             .build())
 *                     .build())
 *                 .osType("Linux")
 *                 .storageProfile(StorageProfileArgs.builder()
 *                     .storageaccounts(StorageAccountArgs.builder()
 *                         .fileSystem("default")
 *                         .isDefault(true)
 *                         .key("storagekey")
 *                         .name("mystorage.dfs.core.windows.net")
 *                         .build())
 *                     .build())
 *                 .tier("Standard")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "val1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Hadoop on Linux cluster with SSH password
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 Configurations = new Dictionary<string, object?>
 *                 {
 *                     ["gateway"] = new Dictionary<string, object?>
 *                     {
 *                         ["restAuthCredential.isEnabled"] = "true",
 *                         ["restAuthCredential.password"] = "**********",
 *                         ["restAuthCredential.username"] = "admin",
 *                     },
 *                 },
 *                 Kind = "Hadoop",
 *             },
 *             ClusterVersion = "3.5",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D3_V2",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D3_V2",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 4,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Small",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "zookeepernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                 },
 *             },
 *             OsType = AzureNative.HDInsight.OSType.Linux,
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "containername",
 *                         IsDefault = true,
 *                         Key = "storagekey",
 *                         Name = "mystorage.blob.core.windows.net",
 *                     },
 *                 },
 *             },
 *             Tier = AzureNative.HDInsight.Tier.Standard,
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * 			ClusterName: pulumi.String("cluster1"),
 * 			Properties: &hdinsight.ClusterCreatePropertiesArgs{
 * 				ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * 					Configurations: pulumi.Any(map[string]interface{}{
 * 						"gateway": map[string]interface{}{
 * 							"restAuthCredential.isEnabled": "true",
 * 							"restAuthCredential.password":  "**********",
 * 							"restAuthCredential.username":  "admin",
 * 						},
 * 					}),
 * 					Kind: pulumi.String("Hadoop"),
 * 				},
 * 				ClusterVersion: pulumi.String("3.5"),
 * 				ComputeProfile: &hdinsight.ComputeProfileArgs{
 * 					Roles: hdinsight.RoleArray{
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Standard_D3_V2"),
 * 							},
 * 							MinInstanceCount: pulumi.Int(1),
 * 							Name:             pulumi.String("headnode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(2),
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Standard_D3_V2"),
 * 							},
 * 							MinInstanceCount: pulumi.Int(1),
 * 							Name:             pulumi.String("workernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(4),
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Small"),
 * 							},
 * 							MinInstanceCount: pulumi.Int(1),
 * 							Name:             pulumi.String("zookeepernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(3),
 * 						},
 * 					},
 * 				},
 * 				OsType: pulumi.String(hdinsight.OSTypeLinux),
 * 				StorageProfile: &hdinsight.StorageProfileArgs{
 * 					Storageaccounts: hdinsight.StorageAccountArray{
 * 						&hdinsight.StorageAccountArgs{
 * 							Container: pulumi.String("containername"),
 * 							IsDefault: pulumi.Bool(true),
 * 							Key:       pulumi.String("storagekey"),
 * 							Name:      pulumi.String("mystorage.blob.core.windows.net"),
 * 						},
 * 					},
 * 				},
 * 				Tier: pulumi.String(hdinsight.TierStandard),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("val1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterCreatePropertiesArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterDefinitionArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ComputeProfileArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.StorageProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(ClusterCreatePropertiesArgs.builder()
 *                 .clusterDefinition(ClusterDefinitionArgs.builder()
 *                     .configurations(Map.of("gateway", Map.ofEntries(
 *                         Map.entry("restAuthCredential.isEnabled", "true"),
 *                         Map.entry("restAuthCredential.password", "**********"),
 *                         Map.entry("restAuthCredential.username", "admin")
 *                     )))
 *                     .kind("Hadoop")
 *                     .build())
 *                 .clusterVersion("3.5")
 *                 .computeProfile(ComputeProfileArgs.builder()
 *                     .roles(
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Standard_D3_V2")
 *                                 .build())
 *                             .minInstanceCount(1)
 *                             .name("headnode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(2)
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Standard_D3_V2")
 *                                 .build())
 *                             .minInstanceCount(1)
 *                             .name("workernode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(4)
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Small")
 *                                 .build())
 *                             .minInstanceCount(1)
 *                             .name("zookeepernode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(3)
 *                             .build())
 *                     .build())
 *                 .osType("Linux")
 *                 .storageProfile(StorageProfileArgs.builder()
 *                     .storageaccounts(StorageAccountArgs.builder()
 *                         .container("containername")
 *                         .isDefault(true)
 *                         .key("storagekey")
 *                         .name("mystorage.blob.core.windows.net")
 *                         .build())
 *                     .build())
 *                 .tier("Standard")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "val1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Hadoop on Linux cluster with SSH public key
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 Configurations = new Dictionary<string, object?>
 *                 {
 *                     ["gateway"] = new Dictionary<string, object?>
 *                     {
 *                         ["restAuthCredential.isEnabled"] = true,
 *                         ["restAuthCredential.password"] = "**********",
 *                         ["restAuthCredential.username"] = "admin",
 *                     },
 *                 },
 *                 Kind = "Hadoop",
 *             },
 *             ClusterVersion = "3.5",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D3_V2",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 SshProfile = new AzureNative.HDInsight.Inputs.SshProfileArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.HDInsight.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             CertificateData = "**********",
 *                                         },
 *                                     },
 *                                 },
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D3_V2",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 4,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Small",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "zookeepernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                 },
 *             },
 *             OsType = AzureNative.HDInsight.OSType.Linux,
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "containername",
 *                         IsDefault = true,
 *                         Key = "storagekey",
 *                         Name = "mystorage.blob.core.windows.net",
 *                     },
 *                 },
 *             },
 *             Tier = AzureNative.HDInsight.Tier.Standard,
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * 			ClusterName: pulumi.String("cluster1"),
 * 			Properties: &hdinsight.ClusterCreatePropertiesArgs{
 * 				ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * 					Configurations: pulumi.Any(map[string]interface{}{
 * 						"gateway": map[string]interface{}{
 * 							"restAuthCredential.isEnabled": true,
 * 							"restAuthCredential.password":  "**********",
 * 							"restAuthCredential.username":  "admin",
 * 						},
 * 					}),
 * 					Kind: pulumi.String("Hadoop"),
 * 				},
 * 				ClusterVersion: pulumi.String("3.5"),
 * 				ComputeProfile: &hdinsight.ComputeProfileArgs{
 * 					Roles: hdinsight.RoleArray{
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Standard_D3_V2"),
 * 							},
 * 							MinInstanceCount: pulumi.Int(1),
 * 							Name:             pulumi.String("headnode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									SshProfile: &hdinsight.SshProfileArgs{
 * 										PublicKeys: hdinsight.SshPublicKeyArray{
 * 											&hdinsight.SshPublicKeyArgs{
 * 												CertificateData: pulumi.String("**********"),
 * 											},
 * 										},
 * 									},
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(2),
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Standard_D3_V2"),
 * 							},
 * 							MinInstanceCount: pulumi.Int(1),
 * 							Name:             pulumi.String("workernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(4),
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Small"),
 * 							},
 * 							MinInstanceCount: pulumi.Int(1),
 * 							Name:             pulumi.String("zookeepernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(3),
 * 						},
 * 					},
 * 				},
 * 				OsType: pulumi.String(hdinsight.OSTypeLinux),
 * 				StorageProfile: &hdinsight.StorageProfileArgs{
 * 					Storageaccounts: hdinsight.StorageAccountArray{
 * 						&hdinsight.StorageAccountArgs{
 * 							Container: pulumi.String("containername"),
 * 							IsDefault: pulumi.Bool(true),
 * 							Key:       pulumi.String("storagekey"),
 * 							Name:      pulumi.String("mystorage.blob.core.windows.net"),
 * 						},
 * 					},
 * 				},
 * 				Tier: pulumi.String(hdinsight.TierStandard),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("val1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterCreatePropertiesArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterDefinitionArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ComputeProfileArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.StorageProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(ClusterCreatePropertiesArgs.builder()
 *                 .clusterDefinition(ClusterDefinitionArgs.builder()
 *                     .configurations(Map.of("gateway", Map.ofEntries(
 *                         Map.entry("restAuthCredential.isEnabled", true),
 *                         Map.entry("restAuthCredential.password", "**********"),
 *                         Map.entry("restAuthCredential.username", "admin")
 *                     )))
 *                     .kind("Hadoop")
 *                     .build())
 *                 .clusterVersion("3.5")
 *                 .computeProfile(ComputeProfileArgs.builder()
 *                     .roles(
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Standard_D3_V2")
 *                                 .build())
 *                             .minInstanceCount(1)
 *                             .name("headnode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .sshProfile(SshProfileArgs.builder()
 *                                         .publicKeys(SshPublicKeyArgs.builder()
 *                                             .certificateData("**********")
 *                                             .build())
 *                                         .build())
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(2)
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Standard_D3_V2")
 *                                 .build())
 *                             .minInstanceCount(1)
 *                             .name("workernode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(4)
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Small")
 *                                 .build())
 *                             .minInstanceCount(1)
 *                             .name("zookeepernode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(3)
 *                             .build())
 *                     .build())
 *                 .osType("Linux")
 *                 .storageProfile(StorageProfileArgs.builder()
 *                     .storageaccounts(StorageAccountArgs.builder()
 *                         .container("containername")
 *                         .isDefault(true)
 *                         .key("storagekey")
 *                         .name("mystorage.blob.core.windows.net")
 *                         .build())
 *                     .build())
 *                 .tier("Standard")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "val1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Kafka cluster with Kafka Rest Proxy
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 ComponentVersion =
 *                 {
 *                     { "Kafka", "2.1" },
 *                 },
 *                 Configurations = new Dictionary<string, object?>
 *                 {
 *                     ["gateway"] = new Dictionary<string, object?>
 *                     {
 *                         ["restAuthCredential.isEnabled"] = true,
 *                         ["restAuthCredential.password"] = "**********",
 *                         ["restAuthCredential.username"] = "admin",
 *                     },
 *                 },
 *                 Kind = "kafka",
 *             },
 *             ClusterVersion = "4.0",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Large",
 *                         },
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         DataDisksGroups = new[]
 *                         {
 *                             new AzureNative.HDInsight.Inputs.DataDisksGroupsArgs
 *                             {
 *                                 DisksPerNode = 8,
 *                             },
 *                         },
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Large",
 *                         },
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Small",
 *                         },
 *                         Name = "zookeepernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D4_v2",
 *                         },
 *                         Name = "kafkamanagementnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "kafkauser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                 },
 *             },
 *             KafkaRestProperties = new AzureNative.HDInsight.Inputs.KafkaRestPropertiesArgs
 *             {
 *                 ClientGroupInfo = new AzureNative.HDInsight.Inputs.ClientGroupInfoArgs
 *                 {
 *                     GroupId = "00000000-0000-0000-0000-111111111111",
 *                     GroupName = "Kafka security group name",
 *                 },
 *             },
 *             OsType = AzureNative.HDInsight.OSType.Linux,
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "containername",
 *                         IsDefault = true,
 *                         Key = "storagekey",
 *                         Name = "mystorage.blob.core.windows.net",
 *                     },
 *                 },
 *             },
 *             Tier = AzureNative.HDInsight.Tier.Standard,
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * 			ClusterName: pulumi.String("cluster1"),
 * 			Properties: &hdinsight.ClusterCreatePropertiesArgs{
 * 				ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * 					ComponentVersion: pulumi.StringMap{
 * 						"Kafka": pulumi.String("2.1"),
 * 					},
 * 					Configurations: pulumi.Any(map[string]interface{}{
 * 						"gateway": map[string]interface{}{
 * 							"restAuthCredential.isEnabled": true,
 * 							"restAuthCredential.password":  "**********",
 * 							"restAuthCredential.username":  "admin",
 * 						},
 * 					}),
 * 					Kind: pulumi.String("kafka"),
 * 				},
 * 				ClusterVersion: pulumi.String("4.0"),
 * 				ComputeProfile: &hdinsight.ComputeProfileArgs{
 * 					Roles: hdinsight.RoleArray{
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Large"),
 * 							},
 * 							Name: pulumi.String("headnode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(2),
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							DataDisksGroups: hdinsight.DataDisksGroupsArray{
 * 								&hdinsight.DataDisksGroupsArgs{
 * 									DisksPerNode: pulumi.Int(8),
 * 								},
 * 							},
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Large"),
 * 							},
 * 							Name: pulumi.String("workernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(3),
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Small"),
 * 							},
 * 							Name: pulumi.String("zookeepernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(3),
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Standard_D4_v2"),
 * 							},
 * 							Name: pulumi.String("kafkamanagementnode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("kafkauser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(2),
 * 						},
 * 					},
 * 				},
 * 				KafkaRestProperties: &hdinsight.KafkaRestPropertiesArgs{
 * 					ClientGroupInfo: &hdinsight.ClientGroupInfoArgs{
 * 						GroupId:   pulumi.String("00000000-0000-0000-0000-111111111111"),
 * 						GroupName: pulumi.String("Kafka security group name"),
 * 					},
 * 				},
 * 				OsType: pulumi.String(hdinsight.OSTypeLinux),
 * 				StorageProfile: &hdinsight.StorageProfileArgs{
 * 					Storageaccounts: hdinsight.StorageAccountArray{
 * 						&hdinsight.StorageAccountArgs{
 * 							Container: pulumi.String("containername"),
 * 							IsDefault: pulumi.Bool(true),
 * 							Key:       pulumi.String("storagekey"),
 * 							Name:      pulumi.String("mystorage.blob.core.windows.net"),
 * 						},
 * 					},
 * 				},
 * 				Tier: pulumi.String(hdinsight.TierStandard),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterCreatePropertiesArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterDefinitionArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ComputeProfileArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.KafkaRestPropertiesArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClientGroupInfoArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.StorageProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(ClusterCreatePropertiesArgs.builder()
 *                 .clusterDefinition(ClusterDefinitionArgs.builder()
 *                     .componentVersion(Map.of("Kafka", "2.1"))
 *                     .configurations(Map.of("gateway", Map.ofEntries(
 *                         Map.entry("restAuthCredential.isEnabled", true),
 *                         Map.entry("restAuthCredential.password", "**********"),
 *                         Map.entry("restAuthCredential.username", "admin")
 *                     )))
 *                     .kind("kafka")
 *                     .build())
 *                 .clusterVersion("4.0")
 *                 .computeProfile(ComputeProfileArgs.builder()
 *                     .roles(
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Large")
 *                                 .build())
 *                             .name("headnode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(2)
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .dataDisksGroups(DataDisksGroupsArgs.builder()
 *                                 .disksPerNode(8)
 *                                 .build())
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Large")
 *                                 .build())
 *                             .name("workernode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(3)
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Small")
 *                                 .build())
 *                             .name("zookeepernode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(3)
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Standard_D4_v2")
 *                                 .build())
 *                             .name("kafkamanagementnode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("kafkauser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(2)
 *                             .build())
 *                     .build())
 *                 .kafkaRestProperties(KafkaRestPropertiesArgs.builder()
 *                     .clientGroupInfo(ClientGroupInfoArgs.builder()
 *                         .groupId("00000000-0000-0000-0000-111111111111")
 *                         .groupName("Kafka security group name")
 *                         .build())
 *                     .build())
 *                 .osType("Linux")
 *                 .storageProfile(StorageProfileArgs.builder()
 *                     .storageaccounts(StorageAccountArgs.builder()
 *                         .container("containername")
 *                         .isDefault(true)
 *                         .key("storagekey")
 *                         .name("mystorage.blob.core.windows.net")
 *                         .build())
 *                     .build())
 *                 .tier("Standard")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create Secure Hadoop cluster
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 Configurations = new Dictionary<string, object?>
 *                 {
 *                     ["gateway"] = new Dictionary<string, object?>
 *                     {
 *                         ["restAuthCredential.isEnabled"] = true,
 *                         ["restAuthCredential.password"] = "**********",
 *                         ["restAuthCredential.username"] = "admin",
 *                     },
 *                 },
 *                 Kind = "Hadoop",
 *             },
 *             ClusterVersion = "3.5",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D3_V2",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 SshProfile = new AzureNative.HDInsight.Inputs.SshProfileArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.HDInsight.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             CertificateData = "**********",
 *                                         },
 *                                     },
 *                                 },
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         ScriptActions = new() { },
 *                         TargetInstanceCount = 2,
 *                         VirtualNetworkProfile = new AzureNative.HDInsight.Inputs.VirtualNetworkProfileArgs
 *                         {
 *                             Id = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname",
 *                             Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
 *                         },
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D3_V2",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 SshProfile = new AzureNative.HDInsight.Inputs.SshProfileArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.HDInsight.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             CertificateData = "**********",
 *                                         },
 *                                     },
 *                                 },
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         ScriptActions = new() { },
 *                         TargetInstanceCount = 4,
 *                         VirtualNetworkProfile = new AzureNative.HDInsight.Inputs.VirtualNetworkProfileArgs
 *                         {
 *                             Id = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname",
 *                             Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
 *                         },
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Small",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "zookeepernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 SshProfile = new AzureNative.HDInsight.Inputs.SshProfileArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.HDInsight.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             CertificateData = "**********",
 *                                         },
 *                                     },
 *                                 },
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         ScriptActions = new() { },
 *                         TargetInstanceCount = 3,
 *                         VirtualNetworkProfile = new AzureNative.HDInsight.Inputs.VirtualNetworkProfileArgs
 *                         {
 *                             Id = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname",
 *                             Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
 *                         },
 *                     },
 *                 },
 *             },
 *             OsType = AzureNative.HDInsight.OSType.Linux,
 *             SecurityProfile = new AzureNative.HDInsight.Inputs.SecurityProfileArgs
 *             {
 *                 ClusterUsersGroupDNs = new[]
 *                 {
 *                     "hdiusers",
 *                 },
 *                 DirectoryType = AzureNative.HDInsight.DirectoryType.ActiveDirectory,
 *                 Domain = "DomainName",
 *                 DomainUserPassword = "**********",
 *                 DomainUsername = "DomainUsername",
 *                 LdapsUrls = new[]
 *                 {
 *                     "ldaps://10.10.0.4:636",
 *                 },
 *                 OrganizationalUnitDN = "OU=Hadoop,DC=hdinsight,DC=test",
 *             },
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "containername",
 *                         IsDefault = true,
 *                         Key = "storage account key",
 *                         Name = "mystorage.blob.core.windows.net",
 *                     },
 *                 },
 *             },
 *             Tier = AzureNative.HDInsight.Tier.Premium,
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * 			ClusterName: pulumi.String("cluster1"),
 * 			Properties: &hdinsight.ClusterCreatePropertiesArgs{
 * 				ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * 					Configurations: pulumi.Any(map[string]interface{}{
 * 						"gateway": map[string]interface{}{
 * 							"restAuthCredential.isEnabled": true,
 * 							"restAuthCredential.password":  "**********",
 * 							"restAuthCredential.username":  "admin",
 * 						},
 * 					}),
 * 					Kind: pulumi.String("Hadoop"),
 * 				},
 * 				ClusterVersion: pulumi.String("3.5"),
 * 				ComputeProfile: &hdinsight.ComputeProfileArgs{
 * 					Roles: hdinsight.RoleArray{
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Standard_D3_V2"),
 * 							},
 * 							MinInstanceCount: pulumi.Int(1),
 * 							Name:             pulumi.String("headnode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									SshProfile: &hdinsight.SshProfileArgs{
 * 										PublicKeys: hdinsight.SshPublicKeyArray{
 * 											&hdinsight.SshPublicKeyArgs{
 * 												CertificateData: pulumi.String("**********"),
 * 											},
 * 										},
 * 									},
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							ScriptActions:       hdinsight.ScriptActionArray{},
 * 							TargetInstanceCount: pulumi.Int(2),
 * 							VirtualNetworkProfile: &hdinsight.VirtualNetworkProfileArgs{
 * 								Id:     pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 * 								Subnet: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet"),
 * 							},
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Standard_D3_V2"),
 * 							},
 * 							MinInstanceCount: pulumi.Int(1),
 * 							Name:             pulumi.String("workernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									SshProfile: &hdinsight.SshProfileArgs{
 * 										PublicKeys: hdinsight.SshPublicKeyArray{
 * 											&hdinsight.SshPublicKeyArgs{
 * 												CertificateData: pulumi.String("**********"),
 * 											},
 * 										},
 * 									},
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							ScriptActions:       hdinsight.ScriptActionArray{},
 * 							TargetInstanceCount: pulumi.Int(4),
 * 							VirtualNetworkProfile: &hdinsight.VirtualNetworkProfileArgs{
 * 								Id:     pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 * 								Subnet: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet"),
 * 							},
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Small"),
 * 							},
 * 							MinInstanceCount: pulumi.Int(1),
 * 							Name:             pulumi.String("zookeepernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									SshProfile: &hdinsight.SshProfileArgs{
 * 										PublicKeys: hdinsight.SshPublicKeyArray{
 * 											&hdinsight.SshPublicKeyArgs{
 * 												CertificateData: pulumi.String("**********"),
 * 											},
 * 										},
 * 									},
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							ScriptActions:       hdinsight.ScriptActionArray{},
 * 							TargetInstanceCount: pulumi.Int(3),
 * 							VirtualNetworkProfile: &hdinsight.VirtualNetworkProfileArgs{
 * 								Id:     pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 * 								Subnet: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				OsType: pulumi.String(hdinsight.OSTypeLinux),
 * 				SecurityProfile: &hdinsight.SecurityProfileArgs{
 * 					ClusterUsersGroupDNs: pulumi.StringArray{
 * 						pulumi.String("hdiusers"),
 * 					},
 * 					DirectoryType:      pulumi.String(hdinsight.DirectoryTypeActiveDirectory),
 * 					Domain:             pulumi.String("DomainName"),
 * 					DomainUserPassword: pulumi.String("**********"),
 * 					DomainUsername:     pulumi.String("DomainUsername"),
 * 					LdapsUrls: pulumi.StringArray{
 * 						pulumi.String("ldaps://10.10.0.4:636"),
 * 					},
 * 					OrganizationalUnitDN: pulumi.String("OU=Hadoop,DC=hdinsight,DC=test"),
 * 				},
 * 				StorageProfile: &hdinsight.StorageProfileArgs{
 * 					Storageaccounts: hdinsight.StorageAccountArray{
 * 						&hdinsight.StorageAccountArgs{
 * 							Container: pulumi.String("containername"),
 * 							IsDefault: pulumi.Bool(true),
 * 							Key:       pulumi.String("storage account key"),
 * 							Name:      pulumi.String("mystorage.blob.core.windows.net"),
 * 						},
 * 					},
 * 				},
 * 				Tier: pulumi.String(hdinsight.TierPremium),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("val1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterCreatePropertiesArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterDefinitionArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ComputeProfileArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.SecurityProfileArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.StorageProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(ClusterCreatePropertiesArgs.builder()
 *                 .clusterDefinition(ClusterDefinitionArgs.builder()
 *                     .configurations(Map.of("gateway", Map.ofEntries(
 *                         Map.entry("restAuthCredential.isEnabled", true),
 *                         Map.entry("restAuthCredential.password", "**********"),
 *                         Map.entry("restAuthCredential.username", "admin")
 *                     )))
 *                     .kind("Hadoop")
 *                     .build())
 *                 .clusterVersion("3.5")
 *                 .computeProfile(ComputeProfileArgs.builder()
 *                     .roles(
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Standard_D3_V2")
 *                                 .build())
 *                             .minInstanceCount(1)
 *                             .name("headnode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .sshProfile(SshProfileArgs.builder()
 *                                         .publicKeys(SshPublicKeyArgs.builder()
 *                                             .certificateData("**********")
 *                                             .build())
 *                                         .build())
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .scriptActions()
 *                             .targetInstanceCount(2)
 *                             .virtualNetworkProfile(VirtualNetworkProfileArgs.builder()
 *                                 .id("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname")
 *                                 .subnet("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet")
 *                                 .build())
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Standard_D3_V2")
 *                                 .build())
 *                             .minInstanceCount(1)
 *                             .name("workernode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .sshProfile(SshProfileArgs.builder()
 *                                         .publicKeys(SshPublicKeyArgs.builder()
 *                                             .certificateData("**********")
 *                                             .build())
 *                                         .build())
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .scriptActions()
 *                             .targetInstanceCount(4)
 *                             .virtualNetworkProfile(VirtualNetworkProfileArgs.builder()
 *                                 .id("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname")
 *                                 .subnet("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet")
 *                                 .build())
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Small")
 *                                 .build())
 *                             .minInstanceCount(1)
 *                             .name("zookeepernode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .sshProfile(SshProfileArgs.builder()
 *                                         .publicKeys(SshPublicKeyArgs.builder()
 *                                             .certificateData("**********")
 *                                             .build())
 *                                         .build())
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .scriptActions()
 *                             .targetInstanceCount(3)
 *                             .virtualNetworkProfile(VirtualNetworkProfileArgs.builder()
 *                                 .id("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname")
 *                                 .subnet("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet")
 *                                 .build())
 *                             .build())
 *                     .build())
 *                 .osType("Linux")
 *                 .securityProfile(SecurityProfileArgs.builder()
 *                     .clusterUsersGroupDNs("hdiusers")
 *                     .directoryType("ActiveDirectory")
 *                     .domain("DomainName")
 *                     .domainUserPassword("**********")
 *                     .domainUsername("DomainUsername")
 *                     .ldapsUrls("ldaps://10.10.0.4:636")
 *                     .organizationalUnitDN("OU=Hadoop,DC=hdinsight,DC=test")
 *                     .build())
 *                 .storageProfile(StorageProfileArgs.builder()
 *                     .storageaccounts(StorageAccountArgs.builder()
 *                         .container("containername")
 *                         .isDefault(true)
 *                         .key("storage account key")
 *                         .name("mystorage.blob.core.windows.net")
 *                         .build())
 *                     .build())
 *                 .tier("Premium")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "val1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create Spark on Linux Cluster with SSH password
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 ComponentVersion =
 *                 {
 *                     { "Spark", "2.0" },
 *                 },
 *                 Configurations = new Dictionary<string, object?>
 *                 {
 *                     ["gateway"] = new Dictionary<string, object?>
 *                     {
 *                         ["restAuthCredential.isEnabled"] = true,
 *                         ["restAuthCredential.password"] = "**********",
 *                         ["restAuthCredential.username"] = "admin",
 *                     },
 *                 },
 *                 Kind = "Spark",
 *             },
 *             ClusterVersion = "3.5",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D12_V2",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_D4_V2",
 *                         },
 *                         MinInstanceCount = 1,
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 4,
 *                     },
 *                 },
 *             },
 *             OsType = AzureNative.HDInsight.OSType.Linux,
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "containername",
 *                         IsDefault = true,
 *                         Key = "storageapikey*",
 *                         Name = "mystorage.blob.core.windows.net",
 *                     },
 *                 },
 *             },
 *             Tier = AzureNative.HDInsight.Tier.Standard,
 *         },
 *         ResourceGroupName = "rg1",
 *         Tags =
 *         {
 *             { "key1", "val1" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * 			ClusterName: pulumi.String("cluster1"),
 * 			Properties: &hdinsight.ClusterCreatePropertiesArgs{
 * 				ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * 					ComponentVersion: pulumi.StringMap{
 * 						"Spark": pulumi.String("2.0"),
 * 					},
 * 					Configurations: pulumi.Any(map[string]interface{}{
 * 						"gateway": map[string]interface{}{
 * 							"restAuthCredential.isEnabled": true,
 * 							"restAuthCredential.password":  "**********",
 * 							"restAuthCredential.username":  "admin",
 * 						},
 * 					}),
 * 					Kind: pulumi.String("Spark"),
 * 				},
 * 				ClusterVersion: pulumi.String("3.5"),
 * 				ComputeProfile: &hdinsight.ComputeProfileArgs{
 * 					Roles: hdinsight.RoleArray{
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Standard_D12_V2"),
 * 							},
 * 							MinInstanceCount: pulumi.Int(1),
 * 							Name:             pulumi.String("headnode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(2),
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Standard_D4_V2"),
 * 							},
 * 							MinInstanceCount: pulumi.Int(1),
 * 							Name:             pulumi.String("workernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(4),
 * 						},
 * 					},
 * 				},
 * 				OsType: pulumi.String(hdinsight.OSTypeLinux),
 * 				StorageProfile: &hdinsight.StorageProfileArgs{
 * 					Storageaccounts: hdinsight.StorageAccountArray{
 * 						&hdinsight.StorageAccountArgs{
 * 							Container: pulumi.String("containername"),
 * 							IsDefault: pulumi.Bool(true),
 * 							Key:       pulumi.String("storageapikey*"),
 * 							Name:      pulumi.String("mystorage.blob.core.windows.net"),
 * 						},
 * 					},
 * 				},
 * 				Tier: pulumi.String(hdinsight.TierStandard),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Tags: pulumi.StringMap{
 * 				"key1": pulumi.String("val1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterCreatePropertiesArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterDefinitionArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ComputeProfileArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.StorageProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(ClusterCreatePropertiesArgs.builder()
 *                 .clusterDefinition(ClusterDefinitionArgs.builder()
 *                     .componentVersion(Map.of("Spark", "2.0"))
 *                     .configurations(Map.of("gateway", Map.ofEntries(
 *                         Map.entry("restAuthCredential.isEnabled", true),
 *                         Map.entry("restAuthCredential.password", "**********"),
 *                         Map.entry("restAuthCredential.username", "admin")
 *                     )))
 *                     .kind("Spark")
 *                     .build())
 *                 .clusterVersion("3.5")
 *                 .computeProfile(ComputeProfileArgs.builder()
 *                     .roles(
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Standard_D12_V2")
 *                                 .build())
 *                             .minInstanceCount(1)
 *                             .name("headnode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(2)
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Standard_D4_V2")
 *                                 .build())
 *                             .minInstanceCount(1)
 *                             .name("workernode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(4)
 *                             .build())
 *                     .build())
 *                 .osType("Linux")
 *                 .storageProfile(StorageProfileArgs.builder()
 *                     .storageaccounts(StorageAccountArgs.builder()
 *                         .container("containername")
 *                         .isDefault(true)
 *                         .key("storageapikey*")
 *                         .name("mystorage.blob.core.windows.net")
 *                         .build())
 *                     .build())
 *                 .tier("Standard")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .tags(Map.of("key1", "val1"))
 *             .build());
 *     }
 * }
 * ```
 * ### Create cluster with TLS 1.2
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 Configurations = new Dictionary<string, object?>
 *                 {
 *                     ["gateway"] = new Dictionary<string, object?>
 *                     {
 *                         ["restAuthCredential.isEnabled"] = true,
 *                         ["restAuthCredential.password"] = "**********",
 *                         ["restAuthCredential.username"] = "admin",
 *                     },
 *                 },
 *                 Kind = "Hadoop",
 *             },
 *             ClusterVersion = "3.6",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Large",
 *                         },
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Large",
 *                         },
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Small",
 *                         },
 *                         Name = "zookeepernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                 },
 *             },
 *             MinSupportedTlsVersion = "1.2",
 *             OsType = AzureNative.HDInsight.OSType.Linux,
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "default8525",
 *                         IsDefault = true,
 *                         Key = "storagekey",
 *                         Name = "mystorage.blob.core.windows.net",
 *                     },
 *                 },
 *             },
 *             Tier = AzureNative.HDInsight.Tier.Standard,
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * 			ClusterName: pulumi.String("cluster1"),
 * 			Properties: &hdinsight.ClusterCreatePropertiesArgs{
 * 				ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * 					Configurations: pulumi.Any(map[string]interface{}{
 * 						"gateway": map[string]interface{}{
 * 							"restAuthCredential.isEnabled": true,
 * 							"restAuthCredential.password":  "**********",
 * 							"restAuthCredential.username":  "admin",
 * 						},
 * 					}),
 * 					Kind: pulumi.String("Hadoop"),
 * 				},
 * 				ClusterVersion: pulumi.String("3.6"),
 * 				ComputeProfile: &hdinsight.ComputeProfileArgs{
 * 					Roles: hdinsight.RoleArray{
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Large"),
 * 							},
 * 							Name: pulumi.String("headnode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(2),
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Large"),
 * 							},
 * 							Name: pulumi.String("workernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(3),
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Small"),
 * 							},
 * 							Name: pulumi.String("zookeepernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(3),
 * 						},
 * 					},
 * 				},
 * 				MinSupportedTlsVersion: pulumi.String("1.2"),
 * 				OsType:                 pulumi.String(hdinsight.OSTypeLinux),
 * 				StorageProfile: &hdinsight.StorageProfileArgs{
 * 					Storageaccounts: hdinsight.StorageAccountArray{
 * 						&hdinsight.StorageAccountArgs{
 * 							Container: pulumi.String("default8525"),
 * 							IsDefault: pulumi.Bool(true),
 * 							Key:       pulumi.String("storagekey"),
 * 							Name:      pulumi.String("mystorage.blob.core.windows.net"),
 * 						},
 * 					},
 * 				},
 * 				Tier: pulumi.String(hdinsight.TierStandard),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterCreatePropertiesArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterDefinitionArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ComputeProfileArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.StorageProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(ClusterCreatePropertiesArgs.builder()
 *                 .clusterDefinition(ClusterDefinitionArgs.builder()
 *                     .configurations(Map.of("gateway", Map.ofEntries(
 *                         Map.entry("restAuthCredential.isEnabled", true),
 *                         Map.entry("restAuthCredential.password", "**********"),
 *                         Map.entry("restAuthCredential.username", "admin")
 *                     )))
 *                     .kind("Hadoop")
 *                     .build())
 *                 .clusterVersion("3.6")
 *                 .computeProfile(ComputeProfileArgs.builder()
 *                     .roles(
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Large")
 *                                 .build())
 *                             .name("headnode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(2)
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Large")
 *                                 .build())
 *                             .name("workernode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(3)
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Small")
 *                                 .build())
 *                             .name("zookeepernode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(3)
 *                             .build())
 *                     .build())
 *                 .minSupportedTlsVersion("1.2")
 *                 .osType("Linux")
 *                 .storageProfile(StorageProfileArgs.builder()
 *                     .storageaccounts(StorageAccountArgs.builder()
 *                         .container("default8525")
 *                         .isDefault(true)
 *                         .key("storagekey")
 *                         .name("mystorage.blob.core.windows.net")
 *                         .build())
 *                     .build())
 *                 .tier("Standard")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create cluster with availability zones
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 Configurations = new Dictionary<string, object?>
 *                 {
 *                     ["ambari-conf"] = new Dictionary<string, object?>
 *                     {
 *                         ["database-name"] = "{ambari database name}",
 *                         ["database-server"] = "{sql server name}.database.windows.net",
 *                         ["database-user-name"] = "**********",
 *                         ["database-user-password"] = "**********",
 *                     },
 *                     ["gateway"] = new Dictionary<string, object?>
 *                     {
 *                         ["restAuthCredential.isEnabled"] = true,
 *                         ["restAuthCredential.password"] = "**********",
 *                         ["restAuthCredential.username"] = "admin",
 *                     },
 *                     ["hive-env"] = new Dictionary<string, object?>
 *                     {
 *                         ["hive_database"] = "Existing MSSQL Server database with SQL authentication",
 *                         ["hive_database_name"] = "{hive metastore name}",
 *                         ["hive_database_type"] = "mssql",
 *                         ["hive_existing_mssql_server_database"] = "{hive metastore name}",
 *                         ["hive_existing_mssql_server_host"] = "{sql server name}.database.windows.net",
 *                         ["hive_hostname"] = "{sql server name}.database.windows.net",
 *                     },
 *                     ["hive-site"] = new Dictionary<string, object?>
 *                     {
 *                         ["javax.jdo.option.ConnectionDriverName"] = "com.microsoft.sqlserver.jdbc.SQLServerDriver",
 *                         ["javax.jdo.option.ConnectionPassword"] = "**********!",
 *                         ["javax.jdo.option.ConnectionURL"] = "jdbc:sqlserver://{sql server name}.database.windows.net;database={hive metastore name};encrypt=true;trustServerCertificate=true;create=false;loginTimeout=300;sendStringParametersAsUnicode=true;prepareSQL=0",
 *                         ["javax.jdo.option.ConnectionUserName"] = "**********",
 *                     },
 *                     ["oozie-env"] = new Dictionary<string, object?>
 *                     {
 *                         ["oozie_database"] = "Existing MSSQL Server database with SQL authentication",
 *                         ["oozie_database_name"] = "{oozie metastore name}",
 *                         ["oozie_database_type"] = "mssql",
 *                         ["oozie_existing_mssql_server_database"] = "{oozie metastore name}",
 *                         ["oozie_existing_mssql_server_host"] = "{sql server name}.database.windows.net",
 *                         ["oozie_hostname"] = "{sql server name}.database.windows.net",
 *                     },
 *                     ["oozie-site"] = new Dictionary<string, object?>
 *                     {
 *                         ["oozie.db.schema.name"] = "oozie",
 *                         ["oozie.service.JPAService.jdbc.driver"] = "com.microsoft.sqlserver.jdbc.SQLServerDriver",
 *                         ["oozie.service.JPAService.jdbc.password"] = "**********",
 *                         ["oozie.service.JPAService.jdbc.url"] = "jdbc:sqlserver://{sql server name}.database.windows.net;database={oozie metastore name};encrypt=true;trustServerCertificate=true;create=false;loginTimeout=300;sendStringParametersAsUnicode=true;prepareSQL=0",
 *                         ["oozie.service.JPAService.jdbc.username"] = "**********",
 *                     },
 *                 },
 *                 Kind = "hadoop",
 *             },
 *             ClusterVersion = "3.6",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "standard_d3",
 *                         },
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 SshProfile = new AzureNative.HDInsight.Inputs.SshProfileArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.HDInsight.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             CertificateData = "**********",
 *                                         },
 *                                     },
 *                                 },
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                         VirtualNetworkProfile = new AzureNative.HDInsight.Inputs.VirtualNetworkProfileArgs
 *                         {
 *                             Id = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname",
 *                             Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
 *                         },
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "standard_d3",
 *                         },
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 SshProfile = new AzureNative.HDInsight.Inputs.SshProfileArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.HDInsight.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             CertificateData = "**********",
 *                                         },
 *                                     },
 *                                 },
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                         VirtualNetworkProfile = new AzureNative.HDInsight.Inputs.VirtualNetworkProfileArgs
 *                         {
 *                             Id = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname",
 *                             Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
 *                         },
 *                     },
 *                 },
 *             },
 *             OsType = AzureNative.HDInsight.OSType.Linux,
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "containername",
 *                         IsDefault = true,
 *                         Key = "storage account key",
 *                         Name = "mystorage",
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *         Zones = new[]
 *         {
 *             "1",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * 			ClusterName: pulumi.String("cluster1"),
 * 			Properties: &hdinsight.ClusterCreatePropertiesArgs{
 * 				ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * 					Configurations: pulumi.Any(map[string]interface{}{
 * 						"ambari-conf": map[string]interface{}{
 * 							"database-name":          "{ambari database name}",
 * 							"database-server":        "{sql server name}.database.windows.net",
 * 							"database-user-name":     "**********",
 * 							"database-user-password": "**********",
 * 						},
 * 						"gateway": map[string]interface{}{
 * 							"restAuthCredential.isEnabled": true,
 * 							"restAuthCredential.password":  "**********",
 * 							"restAuthCredential.username":  "admin",
 * 						},
 * 						"hive-env": map[string]interface{}{
 * 							"hive_database":                       "Existing MSSQL Server database with SQL authentication",
 * 							"hive_database_name":                  "{hive metastore name}",
 * 							"hive_database_type":                  "mssql",
 * 							"hive_existing_mssql_server_database": "{hive metastore name}",
 * 							"hive_existing_mssql_server_host":     "{sql server name}.database.windows.net",
 * 							"hive_hostname":                       "{sql server name}.database.windows.net",
 * 						},
 * 						"hive-site": map[string]interface{}{
 * 							"javax.jdo.option.ConnectionDriverName": "com.microsoft.sqlserver.jdbc.SQLServerDriver",
 * 							"javax.jdo.option.ConnectionPassword":   "**********!",
 * 							"javax.jdo.option.ConnectionURL":        "jdbc:sqlserver://{sql server name}.database.windows.net;database={hive metastore name};encrypt=true;trustServerCertificate=true;create=false;loginTimeout=300;sendStringParametersAsUnicode=true;prepareSQL=0",
 * 							"javax.jdo.option.ConnectionUserName":   "**********",
 * 						},
 * 						"oozie-env": map[string]interface{}{
 * 							"oozie_database":                       "Existing MSSQL Server database with SQL authentication",
 * 							"oozie_database_name":                  "{oozie metastore name}",
 * 							"oozie_database_type":                  "mssql",
 * 							"oozie_existing_mssql_server_database": "{oozie metastore name}",
 * 							"oozie_existing_mssql_server_host":     "{sql server name}.database.windows.net",
 * 							"oozie_hostname":                       "{sql server name}.database.windows.net",
 * 						},
 * 						"oozie-site": map[string]interface{}{
 * 							"oozie.db.schema.name":                   "oozie",
 * 							"oozie.service.JPAService.jdbc.driver":   "com.microsoft.sqlserver.jdbc.SQLServerDriver",
 * 							"oozie.service.JPAService.jdbc.password": "**********",
 * 							"oozie.service.JPAService.jdbc.url":      "jdbc:sqlserver://{sql server name}.database.windows.net;database={oozie metastore name};encrypt=true;trustServerCertificate=true;create=false;loginTimeout=300;sendStringParametersAsUnicode=true;prepareSQL=0",
 * 							"oozie.service.JPAService.jdbc.username": "**********",
 * 						},
 * 					}),
 * 					Kind: pulumi.String("hadoop"),
 * 				},
 * 				ClusterVersion: pulumi.String("3.6"),
 * 				ComputeProfile: &hdinsight.ComputeProfileArgs{
 * 					Roles: hdinsight.RoleArray{
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("standard_d3"),
 * 							},
 * 							Name: pulumi.String("headnode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									SshProfile: &hdinsight.SshProfileArgs{
 * 										PublicKeys: hdinsight.SshPublicKeyArray{
 * 											&hdinsight.SshPublicKeyArgs{
 * 												CertificateData: pulumi.String("**********"),
 * 											},
 * 										},
 * 									},
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(2),
 * 							VirtualNetworkProfile: &hdinsight.VirtualNetworkProfileArgs{
 * 								Id:     pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 * 								Subnet: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet"),
 * 							},
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("standard_d3"),
 * 							},
 * 							Name: pulumi.String("workernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									SshProfile: &hdinsight.SshProfileArgs{
 * 										PublicKeys: hdinsight.SshPublicKeyArray{
 * 											&hdinsight.SshPublicKeyArgs{
 * 												CertificateData: pulumi.String("**********"),
 * 											},
 * 										},
 * 									},
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(2),
 * 							VirtualNetworkProfile: &hdinsight.VirtualNetworkProfileArgs{
 * 								Id:     pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 * 								Subnet: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				OsType: pulumi.String(hdinsight.OSTypeLinux),
 * 				StorageProfile: &hdinsight.StorageProfileArgs{
 * 					Storageaccounts: hdinsight.StorageAccountArray{
 * 						&hdinsight.StorageAccountArgs{
 * 							Container: pulumi.String("containername"),
 * 							IsDefault: pulumi.Bool(true),
 * 							Key:       pulumi.String("storage account key"),
 * 							Name:      pulumi.String("mystorage"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 			Zones: pulumi.StringArray{
 * 				pulumi.String("1"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterCreatePropertiesArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterDefinitionArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ComputeProfileArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.StorageProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(ClusterCreatePropertiesArgs.builder()
 *                 .clusterDefinition(ClusterDefinitionArgs.builder()
 *                     .configurations(Map.ofEntries(
 *                         Map.entry("ambari-conf", Map.ofEntries(
 *                             Map.entry("database-name", "{ambari database name}"),
 *                             Map.entry("database-server", "{sql server name}.database.windows.net"),
 *                             Map.entry("database-user-name", "**********"),
 *                             Map.entry("database-user-password", "**********")
 *                         )),
 *                         Map.entry("gateway", Map.ofEntries(
 *                             Map.entry("restAuthCredential.isEnabled", true),
 *                             Map.entry("restAuthCredential.password", "**********"),
 *                             Map.entry("restAuthCredential.username", "admin")
 *                         )),
 *                         Map.entry("hive-env", Map.ofEntries(
 *                             Map.entry("hive_database", "Existing MSSQL Server database with SQL authentication"),
 *                             Map.entry("hive_database_name", "{hive metastore name}"),
 *                             Map.entry("hive_database_type", "mssql"),
 *                             Map.entry("hive_existing_mssql_server_database", "{hive metastore name}"),
 *                             Map.entry("hive_existing_mssql_server_host", "{sql server name}.database.windows.net"),
 *                             Map.entry("hive_hostname", "{sql server name}.database.windows.net")
 *                         )),
 *                         Map.entry("hive-site", Map.ofEntries(
 *                             Map.entry("javax.jdo.option.ConnectionDriverName", "com.microsoft.sqlserver.jdbc.SQLServerDriver"),
 *                             Map.entry("javax.jdo.option.ConnectionPassword", "**********!"),
 *                             Map.entry("javax.jdo.option.ConnectionURL", "jdbc:sqlserver://{sql server name}.database.windows.net;database={hive metastore name};encrypt=true;trustServerCertificate=true;create=false;loginTimeout=300;sendStringParametersAsUnicode=true;prepareSQL=0"),
 *                             Map.entry("javax.jdo.option.ConnectionUserName", "**********")
 *                         )),
 *                         Map.entry("oozie-env", Map.ofEntries(
 *                             Map.entry("oozie_database", "Existing MSSQL Server database with SQL authentication"),
 *                             Map.entry("oozie_database_name", "{oozie metastore name}"),
 *                             Map.entry("oozie_database_type", "mssql"),
 *                             Map.entry("oozie_existing_mssql_server_database", "{oozie metastore name}"),
 *                             Map.entry("oozie_existing_mssql_server_host", "{sql server name}.database.windows.net"),
 *                             Map.entry("oozie_hostname", "{sql server name}.database.windows.net")
 *                         )),
 *                         Map.entry("oozie-site", Map.ofEntries(
 *                             Map.entry("oozie.db.schema.name", "oozie"),
 *                             Map.entry("oozie.service.JPAService.jdbc.driver", "com.microsoft.sqlserver.jdbc.SQLServerDriver"),
 *                             Map.entry("oozie.service.JPAService.jdbc.password", "**********"),
 *                             Map.entry("oozie.service.JPAService.jdbc.url", "jdbc:sqlserver://{sql server name}.database.windows.net;database={oozie metastore name};encrypt=true;trustServerCertificate=true;create=false;loginTimeout=300;sendStringParametersAsUnicode=true;prepareSQL=0"),
 *                             Map.entry("oozie.service.JPAService.jdbc.username", "**********")
 *                         ))
 *                     ))
 *                     .kind("hadoop")
 *                     .build())
 *                 .clusterVersion("3.6")
 *                 .computeProfile(ComputeProfileArgs.builder()
 *                     .roles(
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("standard_d3")
 *                                 .build())
 *                             .name("headnode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .sshProfile(SshProfileArgs.builder()
 *                                         .publicKeys(SshPublicKeyArgs.builder()
 *                                             .certificateData("**********")
 *                                             .build())
 *                                         .build())
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(2)
 *                             .virtualNetworkProfile(VirtualNetworkProfileArgs.builder()
 *                                 .id("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname")
 *                                 .subnet("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet")
 *                                 .build())
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("standard_d3")
 *                                 .build())
 *                             .name("workernode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .sshProfile(SshProfileArgs.builder()
 *                                         .publicKeys(SshPublicKeyArgs.builder()
 *                                             .certificateData("**********")
 *                                             .build())
 *                                         .build())
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(2)
 *                             .virtualNetworkProfile(VirtualNetworkProfileArgs.builder()
 *                                 .id("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname")
 *                                 .subnet("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet")
 *                                 .build())
 *                             .build())
 *                     .build())
 *                 .osType("Linux")
 *                 .storageProfile(StorageProfileArgs.builder()
 *                     .storageaccounts(StorageAccountArgs.builder()
 *                         .container("containername")
 *                         .isDefault(true)
 *                         .key("storage account key")
 *                         .name("mystorage")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .zones("1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create cluster with compute isolation properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 Configurations = new Dictionary<string, object?>
 *                 {
 *                     ["gateway"] = new Dictionary<string, object?>
 *                     {
 *                         ["restAuthCredential.isEnabled"] = true,
 *                         ["restAuthCredential.password"] = "**********",
 *                         ["restAuthCredential.username"] = "admin",
 *                     },
 *                 },
 *                 Kind = "hadoop",
 *             },
 *             ClusterVersion = "3.6",
 *             ComputeIsolationProperties = new AzureNative.HDInsight.Inputs.ComputeIsolationPropertiesArgs
 *             {
 *                 EnableComputeIsolation = true,
 *             },
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "standard_d3",
 *                         },
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 SshProfile = new AzureNative.HDInsight.Inputs.SshProfileArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.HDInsight.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             CertificateData = "**********",
 *                                         },
 *                                     },
 *                                 },
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "standard_d3",
 *                         },
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 SshProfile = new AzureNative.HDInsight.Inputs.SshProfileArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.HDInsight.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             CertificateData = "**********",
 *                                         },
 *                                     },
 *                                 },
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                 },
 *             },
 *             OsType = AzureNative.HDInsight.OSType.Linux,
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "containername",
 *                         IsDefault = true,
 *                         Key = "storage account key",
 *                         Name = "mystorage",
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * 			ClusterName: pulumi.String("cluster1"),
 * 			Properties: &hdinsight.ClusterCreatePropertiesArgs{
 * 				ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * 					Configurations: pulumi.Any(map[string]interface{}{
 * 						"gateway": map[string]interface{}{
 * 							"restAuthCredential.isEnabled": true,
 * 							"restAuthCredential.password":  "**********",
 * 							"restAuthCredential.username":  "admin",
 * 						},
 * 					}),
 * 					Kind: pulumi.String("hadoop"),
 * 				},
 * 				ClusterVersion: pulumi.String("3.6"),
 * 				ComputeIsolationProperties: &hdinsight.ComputeIsolationPropertiesArgs{
 * 					EnableComputeIsolation: pulumi.Bool(true),
 * 				},
 * 				ComputeProfile: &hdinsight.ComputeProfileArgs{
 * 					Roles: hdinsight.RoleArray{
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("standard_d3"),
 * 							},
 * 							Name: pulumi.String("headnode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									SshProfile: &hdinsight.SshProfileArgs{
 * 										PublicKeys: hdinsight.SshPublicKeyArray{
 * 											&hdinsight.SshPublicKeyArgs{
 * 												CertificateData: pulumi.String("**********"),
 * 											},
 * 										},
 * 									},
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(2),
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("standard_d3"),
 * 							},
 * 							Name: pulumi.String("workernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									SshProfile: &hdinsight.SshProfileArgs{
 * 										PublicKeys: hdinsight.SshPublicKeyArray{
 * 											&hdinsight.SshPublicKeyArgs{
 * 												CertificateData: pulumi.String("**********"),
 * 											},
 * 										},
 * 									},
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(2),
 * 						},
 * 					},
 * 				},
 * 				OsType: pulumi.String(hdinsight.OSTypeLinux),
 * 				StorageProfile: &hdinsight.StorageProfileArgs{
 * 					Storageaccounts: hdinsight.StorageAccountArray{
 * 						&hdinsight.StorageAccountArgs{
 * 							Container: pulumi.String("containername"),
 * 							IsDefault: pulumi.Bool(true),
 * 							Key:       pulumi.String("storage account key"),
 * 							Name:      pulumi.String("mystorage"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterCreatePropertiesArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterDefinitionArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ComputeIsolationPropertiesArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ComputeProfileArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.StorageProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(ClusterCreatePropertiesArgs.builder()
 *                 .clusterDefinition(ClusterDefinitionArgs.builder()
 *                     .configurations(Map.of("gateway", Map.ofEntries(
 *                         Map.entry("restAuthCredential.isEnabled", true),
 *                         Map.entry("restAuthCredential.password", "**********"),
 *                         Map.entry("restAuthCredential.username", "admin")
 *                     )))
 *                     .kind("hadoop")
 *                     .build())
 *                 .clusterVersion("3.6")
 *                 .computeIsolationProperties(ComputeIsolationPropertiesArgs.builder()
 *                     .enableComputeIsolation(true)
 *                     .build())
 *                 .computeProfile(ComputeProfileArgs.builder()
 *                     .roles(
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("standard_d3")
 *                                 .build())
 *                             .name("headnode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .sshProfile(SshProfileArgs.builder()
 *                                         .publicKeys(SshPublicKeyArgs.builder()
 *                                             .certificateData("**********")
 *                                             .build())
 *                                         .build())
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(2)
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("standard_d3")
 *                                 .build())
 *                             .name("workernode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .sshProfile(SshProfileArgs.builder()
 *                                         .publicKeys(SshPublicKeyArgs.builder()
 *                                             .certificateData("**********")
 *                                             .build())
 *                                         .build())
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(2)
 *                             .build())
 *                     .build())
 *                 .osType("Linux")
 *                 .storageProfile(StorageProfileArgs.builder()
 *                     .storageaccounts(StorageAccountArgs.builder()
 *                         .container("containername")
 *                         .isDefault(true)
 *                         .key("storage account key")
 *                         .name("mystorage")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create cluster with encryption at host
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 Configurations = new Dictionary<string, object?>
 *                 {
 *                     ["gateway"] = new Dictionary<string, object?>
 *                     {
 *                         ["restAuthCredential.isEnabled"] = true,
 *                         ["restAuthCredential.password"] = "**********",
 *                         ["restAuthCredential.username"] = "admin",
 *                     },
 *                 },
 *                 Kind = "Hadoop",
 *             },
 *             ClusterVersion = "3.6",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_DS14_v2",
 *                         },
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_DS14_v2",
 *                         },
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Standard_DS14_v2",
 *                         },
 *                         Name = "zookeepernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                 },
 *             },
 *             DiskEncryptionProperties = new AzureNative.HDInsight.Inputs.DiskEncryptionPropertiesArgs
 *             {
 *                 EncryptionAtHost = true,
 *             },
 *             OsType = AzureNative.HDInsight.OSType.Linux,
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "default8525",
 *                         IsDefault = true,
 *                         Key = "storagekey",
 *                         Name = "mystorage.blob.core.windows.net",
 *                     },
 *                 },
 *             },
 *             Tier = AzureNative.HDInsight.Tier.Standard,
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * 			ClusterName: pulumi.String("cluster1"),
 * 			Properties: &hdinsight.ClusterCreatePropertiesArgs{
 * 				ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * 					Configurations: pulumi.Any(map[string]interface{}{
 * 						"gateway": map[string]interface{}{
 * 							"restAuthCredential.isEnabled": true,
 * 							"restAuthCredential.password":  "**********",
 * 							"restAuthCredential.username":  "admin",
 * 						},
 * 					}),
 * 					Kind: pulumi.String("Hadoop"),
 * 				},
 * 				ClusterVersion: pulumi.String("3.6"),
 * 				ComputeProfile: &hdinsight.ComputeProfileArgs{
 * 					Roles: hdinsight.RoleArray{
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Standard_DS14_v2"),
 * 							},
 * 							Name: pulumi.String("headnode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(2),
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Standard_DS14_v2"),
 * 							},
 * 							Name: pulumi.String("workernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(3),
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Standard_DS14_v2"),
 * 							},
 * 							Name: pulumi.String("zookeepernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(3),
 * 						},
 * 					},
 * 				},
 * 				DiskEncryptionProperties: &hdinsight.DiskEncryptionPropertiesArgs{
 * 					EncryptionAtHost: pulumi.Bool(true),
 * 				},
 * 				OsType: pulumi.String(hdinsight.OSTypeLinux),
 * 				StorageProfile: &hdinsight.StorageProfileArgs{
 * 					Storageaccounts: hdinsight.StorageAccountArray{
 * 						&hdinsight.StorageAccountArgs{
 * 							Container: pulumi.String("default8525"),
 * 							IsDefault: pulumi.Bool(true),
 * 							Key:       pulumi.String("storagekey"),
 * 							Name:      pulumi.String("mystorage.blob.core.windows.net"),
 * 						},
 * 					},
 * 				},
 * 				Tier: pulumi.String(hdinsight.TierStandard),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterCreatePropertiesArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterDefinitionArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ComputeProfileArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.DiskEncryptionPropertiesArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.StorageProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(ClusterCreatePropertiesArgs.builder()
 *                 .clusterDefinition(ClusterDefinitionArgs.builder()
 *                     .configurations(Map.of("gateway", Map.ofEntries(
 *                         Map.entry("restAuthCredential.isEnabled", true),
 *                         Map.entry("restAuthCredential.password", "**********"),
 *                         Map.entry("restAuthCredential.username", "admin")
 *                     )))
 *                     .kind("Hadoop")
 *                     .build())
 *                 .clusterVersion("3.6")
 *                 .computeProfile(ComputeProfileArgs.builder()
 *                     .roles(
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Standard_DS14_v2")
 *                                 .build())
 *                             .name("headnode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(2)
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Standard_DS14_v2")
 *                                 .build())
 *                             .name("workernode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(3)
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Standard_DS14_v2")
 *                                 .build())
 *                             .name("zookeepernode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(3)
 *                             .build())
 *                     .build())
 *                 .diskEncryptionProperties(DiskEncryptionPropertiesArgs.builder()
 *                     .encryptionAtHost(true)
 *                     .build())
 *                 .osType("Linux")
 *                 .storageProfile(StorageProfileArgs.builder()
 *                     .storageaccounts(StorageAccountArgs.builder()
 *                         .container("default8525")
 *                         .isDefault(true)
 *                         .key("storagekey")
 *                         .name("mystorage.blob.core.windows.net")
 *                         .build())
 *                     .build())
 *                 .tier("Standard")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create cluster with encryption in transit
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 Configurations = new Dictionary<string, object?>
 *                 {
 *                     ["gateway"] = new Dictionary<string, object?>
 *                     {
 *                         ["restAuthCredential.isEnabled"] = true,
 *                         ["restAuthCredential.password"] = "**********",
 *                         ["restAuthCredential.username"] = "admin",
 *                     },
 *                 },
 *                 Kind = "Hadoop",
 *             },
 *             ClusterVersion = "3.6",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Large",
 *                         },
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Large",
 *                         },
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "Small",
 *                         },
 *                         Name = "zookeepernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 3,
 *                     },
 *                 },
 *             },
 *             EncryptionInTransitProperties = new AzureNative.HDInsight.Inputs.EncryptionInTransitPropertiesArgs
 *             {
 *                 IsEncryptionInTransitEnabled = true,
 *             },
 *             OsType = AzureNative.HDInsight.OSType.Linux,
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "default8525",
 *                         IsDefault = true,
 *                         Key = "storagekey",
 *                         Name = "mystorage.blob.core.windows.net",
 *                     },
 *                 },
 *             },
 *             Tier = AzureNative.HDInsight.Tier.Standard,
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * 			ClusterName: pulumi.String("cluster1"),
 * 			Properties: &hdinsight.ClusterCreatePropertiesArgs{
 * 				ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * 					Configurations: pulumi.Any(map[string]interface{}{
 * 						"gateway": map[string]interface{}{
 * 							"restAuthCredential.isEnabled": true,
 * 							"restAuthCredential.password":  "**********",
 * 							"restAuthCredential.username":  "admin",
 * 						},
 * 					}),
 * 					Kind: pulumi.String("Hadoop"),
 * 				},
 * 				ClusterVersion: pulumi.String("3.6"),
 * 				ComputeProfile: &hdinsight.ComputeProfileArgs{
 * 					Roles: hdinsight.RoleArray{
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Large"),
 * 							},
 * 							Name: pulumi.String("headnode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(2),
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Large"),
 * 							},
 * 							Name: pulumi.String("workernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(3),
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("Small"),
 * 							},
 * 							Name: pulumi.String("zookeepernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(3),
 * 						},
 * 					},
 * 				},
 * 				EncryptionInTransitProperties: &hdinsight.EncryptionInTransitPropertiesArgs{
 * 					IsEncryptionInTransitEnabled: pulumi.Bool(true),
 * 				},
 * 				OsType: pulumi.String(hdinsight.OSTypeLinux),
 * 				StorageProfile: &hdinsight.StorageProfileArgs{
 * 					Storageaccounts: hdinsight.StorageAccountArray{
 * 						&hdinsight.StorageAccountArgs{
 * 							Container: pulumi.String("default8525"),
 * 							IsDefault: pulumi.Bool(true),
 * 							Key:       pulumi.String("storagekey"),
 * 							Name:      pulumi.String("mystorage.blob.core.windows.net"),
 * 						},
 * 					},
 * 				},
 * 				Tier: pulumi.String(hdinsight.TierStandard),
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterCreatePropertiesArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterDefinitionArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ComputeProfileArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.EncryptionInTransitPropertiesArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.StorageProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(ClusterCreatePropertiesArgs.builder()
 *                 .clusterDefinition(ClusterDefinitionArgs.builder()
 *                     .configurations(Map.of("gateway", Map.ofEntries(
 *                         Map.entry("restAuthCredential.isEnabled", true),
 *                         Map.entry("restAuthCredential.password", "**********"),
 *                         Map.entry("restAuthCredential.username", "admin")
 *                     )))
 *                     .kind("Hadoop")
 *                     .build())
 *                 .clusterVersion("3.6")
 *                 .computeProfile(ComputeProfileArgs.builder()
 *                     .roles(
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Large")
 *                                 .build())
 *                             .name("headnode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(2)
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Large")
 *                                 .build())
 *                             .name("workernode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(3)
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("Small")
 *                                 .build())
 *                             .name("zookeepernode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(3)
 *                             .build())
 *                     .build())
 *                 .encryptionInTransitProperties(EncryptionInTransitPropertiesArgs.builder()
 *                     .isEncryptionInTransitEnabled(true)
 *                     .build())
 *                 .osType("Linux")
 *                 .storageProfile(StorageProfileArgs.builder()
 *                     .storageaccounts(StorageAccountArgs.builder()
 *                         .container("default8525")
 *                         .isDefault(true)
 *                         .key("storagekey")
 *                         .name("mystorage.blob.core.windows.net")
 *                         .build())
 *                     .build())
 *                 .tier("Standard")
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ### Create cluster with network properties
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var cluster = new AzureNative.HDInsight.Cluster("cluster", new()
 *     {
 *         ClusterName = "cluster1",
 *         Properties = new AzureNative.HDInsight.Inputs.ClusterCreatePropertiesArgs
 *         {
 *             ClusterDefinition = new AzureNative.HDInsight.Inputs.ClusterDefinitionArgs
 *             {
 *                 Configurations = new Dictionary<string, object?>
 *                 {
 *                     ["gateway"] = new Dictionary<string, object?>
 *                     {
 *                         ["restAuthCredential.isEnabled"] = true,
 *                         ["restAuthCredential.password"] = "**********",
 *                         ["restAuthCredential.username"] = "admin",
 *                     },
 *                 },
 *                 Kind = "hadoop",
 *             },
 *             ClusterVersion = "3.6",
 *             ComputeProfile = new AzureNative.HDInsight.Inputs.ComputeProfileArgs
 *             {
 *                 Roles = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "standard_d3",
 *                         },
 *                         Name = "headnode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 SshProfile = new AzureNative.HDInsight.Inputs.SshProfileArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.HDInsight.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             CertificateData = "**********",
 *                                         },
 *                                     },
 *                                 },
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                         VirtualNetworkProfile = new AzureNative.HDInsight.Inputs.VirtualNetworkProfileArgs
 *                         {
 *                             Id = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname",
 *                             Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
 *                         },
 *                     },
 *                     new AzureNative.HDInsight.Inputs.RoleArgs
 *                     {
 *                         HardwareProfile = new AzureNative.HDInsight.Inputs.HardwareProfileArgs
 *                         {
 *                             VmSize = "standard_d3",
 *                         },
 *                         Name = "workernode",
 *                         OsProfile = new AzureNative.HDInsight.Inputs.OsProfileArgs
 *                         {
 *                             LinuxOperatingSystemProfile = new AzureNative.HDInsight.Inputs.LinuxOperatingSystemProfileArgs
 *                             {
 *                                 Password = "**********",
 *                                 SshProfile = new AzureNative.HDInsight.Inputs.SshProfileArgs
 *                                 {
 *                                     PublicKeys = new[]
 *                                     {
 *                                         new AzureNative.HDInsight.Inputs.SshPublicKeyArgs
 *                                         {
 *                                             CertificateData = "**********",
 *                                         },
 *                                     },
 *                                 },
 *                                 Username = "sshuser",
 *                             },
 *                         },
 *                         TargetInstanceCount = 2,
 *                         VirtualNetworkProfile = new AzureNative.HDInsight.Inputs.VirtualNetworkProfileArgs
 *                         {
 *                             Id = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname",
 *                             Subnet = "/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet",
 *                         },
 *                     },
 *                 },
 *             },
 *             NetworkProperties = new AzureNative.HDInsight.Inputs.NetworkPropertiesArgs
 *             {
 *                 PrivateLink = AzureNative.HDInsight.PrivateLink.Enabled,
 *                 ResourceProviderConnection = AzureNative.HDInsight.ResourceProviderConnection.Outbound,
 *             },
 *             OsType = AzureNative.HDInsight.OSType.Linux,
 *             StorageProfile = new AzureNative.HDInsight.Inputs.StorageProfileArgs
 *             {
 *                 Storageaccounts = new[]
 *                 {
 *                     new AzureNative.HDInsight.Inputs.StorageAccountArgs
 *                     {
 *                         Container = "containername",
 *                         IsDefault = true,
 *                         Key = "storage account key",
 *                         Name = "mystorage",
 *                     },
 *                 },
 *             },
 *         },
 *         ResourceGroupName = "rg1",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/hdinsight/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := hdinsight.NewCluster(ctx, "cluster", &hdinsight.ClusterArgs{
 * 			ClusterName: pulumi.String("cluster1"),
 * 			Properties: &hdinsight.ClusterCreatePropertiesArgs{
 * 				ClusterDefinition: &hdinsight.ClusterDefinitionArgs{
 * 					Configurations: pulumi.Any(map[string]interface{}{
 * 						"gateway": map[string]interface{}{
 * 							"restAuthCredential.isEnabled": true,
 * 							"restAuthCredential.password":  "**********",
 * 							"restAuthCredential.username":  "admin",
 * 						},
 * 					}),
 * 					Kind: pulumi.String("hadoop"),
 * 				},
 * 				ClusterVersion: pulumi.String("3.6"),
 * 				ComputeProfile: &hdinsight.ComputeProfileArgs{
 * 					Roles: hdinsight.RoleArray{
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("standard_d3"),
 * 							},
 * 							Name: pulumi.String("headnode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									SshProfile: &hdinsight.SshProfileArgs{
 * 										PublicKeys: hdinsight.SshPublicKeyArray{
 * 											&hdinsight.SshPublicKeyArgs{
 * 												CertificateData: pulumi.String("**********"),
 * 											},
 * 										},
 * 									},
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(2),
 * 							VirtualNetworkProfile: &hdinsight.VirtualNetworkProfileArgs{
 * 								Id:     pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 * 								Subnet: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet"),
 * 							},
 * 						},
 * 						&hdinsight.RoleArgs{
 * 							HardwareProfile: &hdinsight.HardwareProfileArgs{
 * 								VmSize: pulumi.String("standard_d3"),
 * 							},
 * 							Name: pulumi.String("workernode"),
 * 							OsProfile: &hdinsight.OsProfileArgs{
 * 								LinuxOperatingSystemProfile: &hdinsight.LinuxOperatingSystemProfileArgs{
 * 									Password: pulumi.String("**********"),
 * 									SshProfile: &hdinsight.SshProfileArgs{
 * 										PublicKeys: hdinsight.SshPublicKeyArray{
 * 											&hdinsight.SshPublicKeyArgs{
 * 												CertificateData: pulumi.String("**********"),
 * 											},
 * 										},
 * 									},
 * 									Username: pulumi.String("sshuser"),
 * 								},
 * 							},
 * 							TargetInstanceCount: pulumi.Int(2),
 * 							VirtualNetworkProfile: &hdinsight.VirtualNetworkProfileArgs{
 * 								Id:     pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname"),
 * 								Subnet: pulumi.String("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet"),
 * 							},
 * 						},
 * 					},
 * 				},
 * 				NetworkProperties: &hdinsight.NetworkPropertiesArgs{
 * 					PrivateLink:                pulumi.String(hdinsight.PrivateLinkEnabled),
 * 					ResourceProviderConnection: pulumi.String(hdinsight.ResourceProviderConnectionOutbound),
 * 				},
 * 				OsType: pulumi.String(hdinsight.OSTypeLinux),
 * 				StorageProfile: &hdinsight.StorageProfileArgs{
 * 					Storageaccounts: hdinsight.StorageAccountArray{
 * 						&hdinsight.StorageAccountArgs{
 * 							Container: pulumi.String("containername"),
 * 							IsDefault: pulumi.Bool(true),
 * 							Key:       pulumi.String("storage account key"),
 * 							Name:      pulumi.String("mystorage"),
 * 						},
 * 					},
 * 				},
 * 			},
 * 			ResourceGroupName: pulumi.String("rg1"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.hdinsight.Cluster;
 * import com.pulumi.azurenative.hdinsight.ClusterArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterCreatePropertiesArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ClusterDefinitionArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.ComputeProfileArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.NetworkPropertiesArgs;
 * import com.pulumi.azurenative.hdinsight.inputs.StorageProfileArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var cluster = new Cluster("cluster", ClusterArgs.builder()
 *             .clusterName("cluster1")
 *             .properties(ClusterCreatePropertiesArgs.builder()
 *                 .clusterDefinition(ClusterDefinitionArgs.builder()
 *                     .configurations(Map.of("gateway", Map.ofEntries(
 *                         Map.entry("restAuthCredential.isEnabled", true),
 *                         Map.entry("restAuthCredential.password", "**********"),
 *                         Map.entry("restAuthCredential.username", "admin")
 *                     )))
 *                     .kind("hadoop")
 *                     .build())
 *                 .clusterVersion("3.6")
 *                 .computeProfile(ComputeProfileArgs.builder()
 *                     .roles(
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("standard_d3")
 *                                 .build())
 *                             .name("headnode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .sshProfile(SshProfileArgs.builder()
 *                                         .publicKeys(SshPublicKeyArgs.builder()
 *                                             .certificateData("**********")
 *                                             .build())
 *                                         .build())
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(2)
 *                             .virtualNetworkProfile(VirtualNetworkProfileArgs.builder()
 *                                 .id("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname")
 *                                 .subnet("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet")
 *                                 .build())
 *                             .build(),
 *                         RoleArgs.builder()
 *                             .hardwareProfile(HardwareProfileArgs.builder()
 *                                 .vmSize("standard_d3")
 *                                 .build())
 *                             .name("workernode")
 *                             .osProfile(OsProfileArgs.builder()
 *                                 .linuxOperatingSystemProfile(LinuxOperatingSystemProfileArgs.builder()
 *                                     .password("**********")
 *                                     .sshProfile(SshProfileArgs.builder()
 *                                         .publicKeys(SshPublicKeyArgs.builder()
 *                                             .certificateData("**********")
 *                                             .build())
 *                                         .build())
 *                                     .username("sshuser")
 *                                     .build())
 *                                 .build())
 *                             .targetInstanceCount(2)
 *                             .virtualNetworkProfile(VirtualNetworkProfileArgs.builder()
 *                                 .id("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname")
 *                                 .subnet("/subscriptions/subId/resourceGroups/rg/providers/Microsoft.Network/virtualNetworks/vnetname/subnets/vnetsubnet")
 *                                 .build())
 *                             .build())
 *                     .build())
 *                 .networkProperties(NetworkPropertiesArgs.builder()
 *                     .privateLink("Enabled")
 *                     .resourceProviderConnection("Outbound")
 *                     .build())
 *                 .osType("Linux")
 *                 .storageProfile(StorageProfileArgs.builder()
 *                     .storageaccounts(StorageAccountArgs.builder()
 *                         .container("containername")
 *                         .isDefault(true)
 *                         .key("storage account key")
 *                         .name("mystorage")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .resourceGroupName("rg1")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:hdinsight:Cluster cluster1 /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.HDInsight/clusters/{clusterName}
 * ```
 */
public class Cluster internal constructor(
    override val javaResource: com.pulumi.azurenative.hdinsight.Cluster,
) : KotlinCustomResource(javaResource, ClusterMapper) {
    /**
     * The ETag for the resource
     */
    public val etag: Output<String>?
        get() = javaResource.etag().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * The identity of the cluster, if configured.
     */
    public val identity: Output<ClusterIdentityResponse>?
        get() = javaResource.identity().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    clusterIdentityResponseToKotlin(args0)
                })
            }).orElse(null)
        })

    /**
     * The geo-location where the resource lives
     */
    public val location: Output<String>
        get() = javaResource.location().applyValue({ args0 -> args0 })

    /**
     * The name of the resource
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * The properties of the cluster.
     */
    public val properties: Output<ClusterGetPropertiesResponse>
        get() = javaResource.properties().applyValue({ args0 ->
            args0.let({ args0 ->
                clusterGetPropertiesResponseToKotlin(args0)
            })
        })

    /**
     * Metadata pertaining to creation and last modification of the resource.
     */
    public val systemData: Output<SystemDataResponse>
        get() = javaResource.systemData().applyValue({ args0 ->
            args0.let({ args0 ->
                systemDataResponseToKotlin(args0)
            })
        })

    /**
     * Resource tags.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or "Microsoft.Storage/storageAccounts"
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })

    /**
     * The availability zones.
     */
    public val zones: Output<List<String>>?
        get() = javaResource.zones().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0
                })
            }).orElse(null)
        })
}

public object ClusterMapper : ResourceMapper<Cluster> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.hdinsight.Cluster::class == javaResource::class

    override fun map(javaResource: Resource): Cluster = Cluster(
        javaResource as
            com.pulumi.azurenative.hdinsight.Cluster,
    )
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Cluster].
 */
public suspend fun cluster(name: String, block: suspend ClusterResourceBuilder.() -> Unit): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Cluster].
 * @param name The _unique_ name of the resulting resource.
 */
public fun cluster(name: String): Cluster {
    val builder = ClusterResourceBuilder()
    builder.name(name)
    return builder.build()
}
