@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.ApplicationPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The HDInsight cluster application GET response.
 * @property applicationType The application type.
 * @property computeProfile The list of roles in the cluster.
 * @property errors The list of errors.
 * @property httpsEndpoints The list of application HTTPS endpoints.
 * @property installScriptActions The list of install script actions.
 * @property privateLinkConfigurations The private link configurations.
 * @property sshEndpoints The list of application SSH endpoints.
 * @property uninstallScriptActions The list of uninstall script actions.
 */
public data class ApplicationPropertiesArgs(
    public val applicationType: Output<String>? = null,
    public val computeProfile: Output<ComputeProfileArgs>? = null,
    public val errors: Output<List<ErrorsArgs>>? = null,
    public val httpsEndpoints: Output<List<ApplicationGetHttpsEndpointArgs>>? = null,
    public val installScriptActions: Output<List<RuntimeScriptActionArgs>>? = null,
    public val privateLinkConfigurations: Output<List<PrivateLinkConfigurationArgs>>? = null,
    public val sshEndpoints: Output<List<ApplicationGetEndpointArgs>>? = null,
    public val uninstallScriptActions: Output<List<RuntimeScriptActionArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.ApplicationPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.ApplicationPropertiesArgs =
        com.pulumi.azurenative.hdinsight.inputs.ApplicationPropertiesArgs.builder()
            .applicationType(applicationType?.applyValue({ args0 -> args0 }))
            .computeProfile(computeProfile?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .errors(errors?.applyValue({ args0 -> args0.map({ args0 -> args0.let({ args0 -> args0.toJava() }) }) }))
            .httpsEndpoints(
                httpsEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .installScriptActions(
                installScriptActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .privateLinkConfigurations(
                privateLinkConfigurations?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .sshEndpoints(
                sshEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .uninstallScriptActions(
                uninstallScriptActions?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [ApplicationPropertiesArgs].
 */
@PulumiTagMarker
public class ApplicationPropertiesArgsBuilder internal constructor() {
    private var applicationType: Output<String>? = null

    private var computeProfile: Output<ComputeProfileArgs>? = null

    private var errors: Output<List<ErrorsArgs>>? = null

    private var httpsEndpoints: Output<List<ApplicationGetHttpsEndpointArgs>>? = null

    private var installScriptActions: Output<List<RuntimeScriptActionArgs>>? = null

    private var privateLinkConfigurations: Output<List<PrivateLinkConfigurationArgs>>? = null

    private var sshEndpoints: Output<List<ApplicationGetEndpointArgs>>? = null

    private var uninstallScriptActions: Output<List<RuntimeScriptActionArgs>>? = null

    /**
     * @param value The application type.
     */
    @JvmName("dxrktdaehgtsnbpg")
    public suspend fun applicationType(`value`: Output<String>) {
        this.applicationType = value
    }

    /**
     * @param value The list of roles in the cluster.
     */
    @JvmName("fqvrehexeulgsrop")
    public suspend fun computeProfile(`value`: Output<ComputeProfileArgs>) {
        this.computeProfile = value
    }

    /**
     * @param value The list of errors.
     */
    @JvmName("qjjxnvkheaepyluh")
    public suspend fun errors(`value`: Output<List<ErrorsArgs>>) {
        this.errors = value
    }

    @JvmName("wurcdfeyplnenjms")
    public suspend fun errors(vararg values: Output<ErrorsArgs>) {
        this.errors = Output.all(values.asList())
    }

    /**
     * @param values The list of errors.
     */
    @JvmName("qxmerxvuufmndxgv")
    public suspend fun errors(values: List<Output<ErrorsArgs>>) {
        this.errors = Output.all(values)
    }

    /**
     * @param value The list of application HTTPS endpoints.
     */
    @JvmName("nmomsbocnxoxutyd")
    public suspend fun httpsEndpoints(`value`: Output<List<ApplicationGetHttpsEndpointArgs>>) {
        this.httpsEndpoints = value
    }

    @JvmName("pgphpddsrfvnojkj")
    public suspend fun httpsEndpoints(vararg values: Output<ApplicationGetHttpsEndpointArgs>) {
        this.httpsEndpoints = Output.all(values.asList())
    }

    /**
     * @param values The list of application HTTPS endpoints.
     */
    @JvmName("oovwnwteqgdgauoq")
    public suspend fun httpsEndpoints(values: List<Output<ApplicationGetHttpsEndpointArgs>>) {
        this.httpsEndpoints = Output.all(values)
    }

    /**
     * @param value The list of install script actions.
     */
    @JvmName("wyptmurejtbeovsr")
    public suspend fun installScriptActions(`value`: Output<List<RuntimeScriptActionArgs>>) {
        this.installScriptActions = value
    }

    @JvmName("nyylsxcghdgwrupx")
    public suspend fun installScriptActions(vararg values: Output<RuntimeScriptActionArgs>) {
        this.installScriptActions = Output.all(values.asList())
    }

    /**
     * @param values The list of install script actions.
     */
    @JvmName("maiedgigposevtjm")
    public suspend fun installScriptActions(values: List<Output<RuntimeScriptActionArgs>>) {
        this.installScriptActions = Output.all(values)
    }

    /**
     * @param value The private link configurations.
     */
    @JvmName("slnqqjnftrypfedf")
    public suspend fun privateLinkConfigurations(`value`: Output<List<PrivateLinkConfigurationArgs>>) {
        this.privateLinkConfigurations = value
    }

    @JvmName("hqdpxpvqasxkmuim")
    public suspend fun privateLinkConfigurations(vararg values: Output<PrivateLinkConfigurationArgs>) {
        this.privateLinkConfigurations = Output.all(values.asList())
    }

    /**
     * @param values The private link configurations.
     */
    @JvmName("aymxjsmedblvpqsq")
    public suspend fun privateLinkConfigurations(values: List<Output<PrivateLinkConfigurationArgs>>) {
        this.privateLinkConfigurations = Output.all(values)
    }

    /**
     * @param value The list of application SSH endpoints.
     */
    @JvmName("jcbanejcjgpotjsc")
    public suspend fun sshEndpoints(`value`: Output<List<ApplicationGetEndpointArgs>>) {
        this.sshEndpoints = value
    }

    @JvmName("aigrychiondfqetw")
    public suspend fun sshEndpoints(vararg values: Output<ApplicationGetEndpointArgs>) {
        this.sshEndpoints = Output.all(values.asList())
    }

    /**
     * @param values The list of application SSH endpoints.
     */
    @JvmName("actgwdgjljxqxlvf")
    public suspend fun sshEndpoints(values: List<Output<ApplicationGetEndpointArgs>>) {
        this.sshEndpoints = Output.all(values)
    }

    /**
     * @param value The list of uninstall script actions.
     */
    @JvmName("jsshkirjyngyutvo")
    public suspend fun uninstallScriptActions(`value`: Output<List<RuntimeScriptActionArgs>>) {
        this.uninstallScriptActions = value
    }

    @JvmName("redemjhfhllxoqui")
    public suspend fun uninstallScriptActions(vararg values: Output<RuntimeScriptActionArgs>) {
        this.uninstallScriptActions = Output.all(values.asList())
    }

    /**
     * @param values The list of uninstall script actions.
     */
    @JvmName("yleysylgcilgxwob")
    public suspend fun uninstallScriptActions(values: List<Output<RuntimeScriptActionArgs>>) {
        this.uninstallScriptActions = Output.all(values)
    }

    /**
     * @param value The application type.
     */
    @JvmName("yidkwyxuusptwglu")
    public suspend fun applicationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationType = mapped
    }

    /**
     * @param value The list of roles in the cluster.
     */
    @JvmName("euqkmgnhvgflhbpp")
    public suspend fun computeProfile(`value`: ComputeProfileArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeProfile = mapped
    }

    /**
     * @param argument The list of roles in the cluster.
     */
    @JvmName("updffxyljhwlntjp")
    public suspend fun computeProfile(argument: suspend ComputeProfileArgsBuilder.() -> Unit) {
        val toBeMapped = ComputeProfileArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.computeProfile = mapped
    }

    /**
     * @param value The list of errors.
     */
    @JvmName("cfyvnstorvsebqns")
    public suspend fun errors(`value`: List<ErrorsArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.errors = mapped
    }

    /**
     * @param argument The list of errors.
     */
    @JvmName("ugwuxxqgcxgcfjac")
    public suspend fun errors(argument: List<suspend ErrorsArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { ErrorsArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.errors = mapped
    }

    /**
     * @param argument The list of errors.
     */
    @JvmName("tufaonuxnkblirhj")
    public suspend fun errors(vararg argument: suspend ErrorsArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { ErrorsArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.errors = mapped
    }

    /**
     * @param argument The list of errors.
     */
    @JvmName("uslfukaoestgfpgs")
    public suspend fun errors(argument: suspend ErrorsArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ErrorsArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.errors = mapped
    }

    /**
     * @param values The list of errors.
     */
    @JvmName("igrawfumxeewejue")
    public suspend fun errors(vararg values: ErrorsArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.errors = mapped
    }

    /**
     * @param value The list of application HTTPS endpoints.
     */
    @JvmName("iwypvpdcdoegripg")
    public suspend fun httpsEndpoints(`value`: List<ApplicationGetHttpsEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpsEndpoints = mapped
    }

    /**
     * @param argument The list of application HTTPS endpoints.
     */
    @JvmName("syndvayewmxbdxch")
    public suspend fun httpsEndpoints(argument: List<suspend ApplicationGetHttpsEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGetHttpsEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.httpsEndpoints = mapped
    }

    /**
     * @param argument The list of application HTTPS endpoints.
     */
    @JvmName("chywdnmgbebokrdb")
    public suspend fun httpsEndpoints(vararg argument: suspend ApplicationGetHttpsEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationGetHttpsEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.httpsEndpoints = mapped
    }

    /**
     * @param argument The list of application HTTPS endpoints.
     */
    @JvmName("jcuivkubwnanmyff")
    public suspend fun httpsEndpoints(argument: suspend ApplicationGetHttpsEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ApplicationGetHttpsEndpointArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.httpsEndpoints = mapped
    }

    /**
     * @param values The list of application HTTPS endpoints.
     */
    @JvmName("mnnbcoacdhvyaaqy")
    public suspend fun httpsEndpoints(vararg values: ApplicationGetHttpsEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.httpsEndpoints = mapped
    }

    /**
     * @param value The list of install script actions.
     */
    @JvmName("xweeoiegcosfukwo")
    public suspend fun installScriptActions(`value`: List<RuntimeScriptActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.installScriptActions = mapped
    }

    /**
     * @param argument The list of install script actions.
     */
    @JvmName("jrpkyuqrnsmrxnby")
    public suspend fun installScriptActions(argument: List<suspend RuntimeScriptActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuntimeScriptActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.installScriptActions = mapped
    }

    /**
     * @param argument The list of install script actions.
     */
    @JvmName("jgpjcucmsahqwpos")
    public suspend fun installScriptActions(vararg argument: suspend RuntimeScriptActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuntimeScriptActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.installScriptActions = mapped
    }

    /**
     * @param argument The list of install script actions.
     */
    @JvmName("oeyhdfdrfajngkor")
    public suspend fun installScriptActions(argument: suspend RuntimeScriptActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RuntimeScriptActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.installScriptActions = mapped
    }

    /**
     * @param values The list of install script actions.
     */
    @JvmName("hlyuuctooccyiwsd")
    public suspend fun installScriptActions(vararg values: RuntimeScriptActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.installScriptActions = mapped
    }

    /**
     * @param value The private link configurations.
     */
    @JvmName("xxoolpxrhadbrowb")
    public suspend fun privateLinkConfigurations(`value`: List<PrivateLinkConfigurationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.privateLinkConfigurations = mapped
    }

    /**
     * @param argument The private link configurations.
     */
    @JvmName("qlwriiyqrrsymljd")
    public suspend fun privateLinkConfigurations(argument: List<suspend PrivateLinkConfigurationArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PrivateLinkConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateLinkConfigurations = mapped
    }

    /**
     * @param argument The private link configurations.
     */
    @JvmName("owykacwordwckudm")
    public suspend fun privateLinkConfigurations(vararg argument: suspend PrivateLinkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PrivateLinkConfigurationArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.privateLinkConfigurations = mapped
    }

    /**
     * @param argument The private link configurations.
     */
    @JvmName("lidxckpbqpeoewjk")
    public suspend fun privateLinkConfigurations(argument: suspend PrivateLinkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            PrivateLinkConfigurationArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.privateLinkConfigurations = mapped
    }

    /**
     * @param values The private link configurations.
     */
    @JvmName("vvjmxoabhxxgxiip")
    public suspend fun privateLinkConfigurations(vararg values: PrivateLinkConfigurationArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.privateLinkConfigurations = mapped
    }

    /**
     * @param value The list of application SSH endpoints.
     */
    @JvmName("jwuyggrlwebqqbhu")
    public suspend fun sshEndpoints(`value`: List<ApplicationGetEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sshEndpoints = mapped
    }

    /**
     * @param argument The list of application SSH endpoints.
     */
    @JvmName("hvmrliuycssswrfg")
    public suspend fun sshEndpoints(argument: List<suspend ApplicationGetEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ApplicationGetEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sshEndpoints = mapped
    }

    /**
     * @param argument The list of application SSH endpoints.
     */
    @JvmName("fjckfggychucgrbh")
    public suspend fun sshEndpoints(vararg argument: suspend ApplicationGetEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ApplicationGetEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.sshEndpoints = mapped
    }

    /**
     * @param argument The list of application SSH endpoints.
     */
    @JvmName("ijglibxnmsylmudm")
    public suspend fun sshEndpoints(argument: suspend ApplicationGetEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ApplicationGetEndpointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.sshEndpoints = mapped
    }

    /**
     * @param values The list of application SSH endpoints.
     */
    @JvmName("dfajylvyxjoglgep")
    public suspend fun sshEndpoints(vararg values: ApplicationGetEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sshEndpoints = mapped
    }

    /**
     * @param value The list of uninstall script actions.
     */
    @JvmName("pkgccswyfjklplxj")
    public suspend fun uninstallScriptActions(`value`: List<RuntimeScriptActionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.uninstallScriptActions = mapped
    }

    /**
     * @param argument The list of uninstall script actions.
     */
    @JvmName("mghsmunqvqnnnirj")
    public suspend fun uninstallScriptActions(argument: List<suspend RuntimeScriptActionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            RuntimeScriptActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.uninstallScriptActions = mapped
    }

    /**
     * @param argument The list of uninstall script actions.
     */
    @JvmName("lxeuypvjqcvfcxlq")
    public suspend fun uninstallScriptActions(vararg argument: suspend RuntimeScriptActionArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            RuntimeScriptActionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.uninstallScriptActions = mapped
    }

    /**
     * @param argument The list of uninstall script actions.
     */
    @JvmName("lrgpnnofypagfqpb")
    public suspend fun uninstallScriptActions(argument: suspend RuntimeScriptActionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RuntimeScriptActionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.uninstallScriptActions = mapped
    }

    /**
     * @param values The list of uninstall script actions.
     */
    @JvmName("gblgbwervtmqevwc")
    public suspend fun uninstallScriptActions(vararg values: RuntimeScriptActionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.uninstallScriptActions = mapped
    }

    internal fun build(): ApplicationPropertiesArgs = ApplicationPropertiesArgs(
        applicationType = applicationType,
        computeProfile = computeProfile,
        errors = errors,
        httpsEndpoints = httpsEndpoints,
        installScriptActions = installScriptActions,
        privateLinkConfigurations = privateLinkConfigurations,
        sshEndpoints = sshEndpoints,
        uninstallScriptActions = uninstallScriptActions,
    )
}
