@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.AutoscaleCapacityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The load-based autoscale request parameters
 * @property maxInstanceCount The maximum instance count of the cluster
 * @property minInstanceCount The minimum instance count of the cluster
 */
public data class AutoscaleCapacityArgs(
    public val maxInstanceCount: Output<Int>? = null,
    public val minInstanceCount: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.AutoscaleCapacityArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.AutoscaleCapacityArgs =
        com.pulumi.azurenative.hdinsight.inputs.AutoscaleCapacityArgs.builder()
            .maxInstanceCount(maxInstanceCount?.applyValue({ args0 -> args0 }))
            .minInstanceCount(minInstanceCount?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AutoscaleCapacityArgs].
 */
@PulumiTagMarker
public class AutoscaleCapacityArgsBuilder internal constructor() {
    private var maxInstanceCount: Output<Int>? = null

    private var minInstanceCount: Output<Int>? = null

    /**
     * @param value The maximum instance count of the cluster
     */
    @JvmName("ssyhghrpnomyxtfv")
    public suspend fun maxInstanceCount(`value`: Output<Int>) {
        this.maxInstanceCount = value
    }

    /**
     * @param value The minimum instance count of the cluster
     */
    @JvmName("xavrobyloqsrkfen")
    public suspend fun minInstanceCount(`value`: Output<Int>) {
        this.minInstanceCount = value
    }

    /**
     * @param value The maximum instance count of the cluster
     */
    @JvmName("cigqvmmcldgcmyjq")
    public suspend fun maxInstanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxInstanceCount = mapped
    }

    /**
     * @param value The minimum instance count of the cluster
     */
    @JvmName("jmpnuvhshauarjao")
    public suspend fun minInstanceCount(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.minInstanceCount = mapped
    }

    internal fun build(): AutoscaleCapacityArgs = AutoscaleCapacityArgs(
        maxInstanceCount = maxInstanceCount,
        minInstanceCount = minInstanceCount,
    )
}
