@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.ClusterPoolResourcePropertiesComputeProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * CLuster pool compute profile.
 * @property vmSize The virtual machine SKU.
 */
public data class ClusterPoolResourcePropertiesComputeProfileArgs(
    public val vmSize: Output<String>,
) :
    ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.ClusterPoolResourcePropertiesComputeProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.ClusterPoolResourcePropertiesComputeProfileArgs =
        com.pulumi.azurenative.hdinsight.inputs.ClusterPoolResourcePropertiesComputeProfileArgs.builder()
            .vmSize(vmSize.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterPoolResourcePropertiesComputeProfileArgs].
 */
@PulumiTagMarker
public class ClusterPoolResourcePropertiesComputeProfileArgsBuilder internal constructor() {
    private var vmSize: Output<String>? = null

    /**
     * @param value The virtual machine SKU.
     */
    @JvmName("ooafwyrpkkijghnj")
    public suspend fun vmSize(`value`: Output<String>) {
        this.vmSize = value
    }

    /**
     * @param value The virtual machine SKU.
     */
    @JvmName("qlcrxvwyffbjgpdc")
    public suspend fun vmSize(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.vmSize = mapped
    }

    internal fun build(): ClusterPoolResourcePropertiesComputeProfileArgs =
        ClusterPoolResourcePropertiesComputeProfileArgs(
            vmSize = vmSize ?: throw PulumiNullFieldException("vmSize"),
        )
}
