@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.ClusterPoolResourcePropertiesLogAnalyticsProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Cluster pool log analytics profile to enable OMS agent for AKS cluster.
 * @property enabled True if log analytics is enabled for cluster pool, otherwise false.
 * @property workspaceId Log analytics workspace to associate with the OMS agent.
 */
public data class ClusterPoolResourcePropertiesLogAnalyticsProfileArgs(
    public val enabled: Output<Boolean>,
    public val workspaceId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.ClusterPoolResourcePropertiesLogAnalyticsProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.ClusterPoolResourcePropertiesLogAnalyticsProfileArgs =
        com.pulumi.azurenative.hdinsight.inputs.ClusterPoolResourcePropertiesLogAnalyticsProfileArgs.builder()
            .enabled(enabled.applyValue({ args0 -> args0 }))
            .workspaceId(workspaceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ClusterPoolResourcePropertiesLogAnalyticsProfileArgs].
 */
@PulumiTagMarker
public class ClusterPoolResourcePropertiesLogAnalyticsProfileArgsBuilder internal constructor() {
    private var enabled: Output<Boolean>? = null

    private var workspaceId: Output<String>? = null

    /**
     * @param value True if log analytics is enabled for cluster pool, otherwise false.
     */
    @JvmName("kwdgdooxqtijdmea")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value Log analytics workspace to associate with the OMS agent.
     */
    @JvmName("qfsdhdwenxjuhogs")
    public suspend fun workspaceId(`value`: Output<String>) {
        this.workspaceId = value
    }

    /**
     * @param value True if log analytics is enabled for cluster pool, otherwise false.
     */
    @JvmName("gabdlubdxjrwckxs")
    public suspend fun enabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value Log analytics workspace to associate with the OMS agent.
     */
    @JvmName("anpbtwxwvesjbyls")
    public suspend fun workspaceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceId = mapped
    }

    internal fun build(): ClusterPoolResourcePropertiesLogAnalyticsProfileArgs =
        ClusterPoolResourcePropertiesLogAnalyticsProfileArgs(
            enabled = enabled ?: throw PulumiNullFieldException("enabled"),
            workspaceId = workspaceId,
        )
}
