@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.ComputeProfileArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Describes the compute profile.
 * @property roles The list of roles in the cluster.
 */
public data class ComputeProfileArgs(
    public val roles: Output<List<RoleArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.ComputeProfileArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.ComputeProfileArgs =
        com.pulumi.azurenative.hdinsight.inputs.ComputeProfileArgs.builder()
            .roles(
                roles?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ComputeProfileArgs].
 */
@PulumiTagMarker
public class ComputeProfileArgsBuilder internal constructor() {
    private var roles: Output<List<RoleArgs>>? = null

    /**
     * @param value The list of roles in the cluster.
     */
    @JvmName("ricioabhtwiwvrqf")
    public suspend fun roles(`value`: Output<List<RoleArgs>>) {
        this.roles = value
    }

    @JvmName("dmwjuejhjitfbagt")
    public suspend fun roles(vararg values: Output<RoleArgs>) {
        this.roles = Output.all(values.asList())
    }

    /**
     * @param values The list of roles in the cluster.
     */
    @JvmName("rrmqlqbducstkfsk")
    public suspend fun roles(values: List<Output<RoleArgs>>) {
        this.roles = Output.all(values)
    }

    /**
     * @param value The list of roles in the cluster.
     */
    @JvmName("aetrskvqwkacrbbp")
    public suspend fun roles(`value`: List<RoleArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    /**
     * @param argument The list of roles in the cluster.
     */
    @JvmName("crpqeduitfkhednc")
    public suspend fun roles(argument: List<suspend RoleArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map { RoleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param argument The list of roles in the cluster.
     */
    @JvmName("iekntgsbemlxonqk")
    public suspend fun roles(vararg argument: suspend RoleArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map { RoleArgsBuilder().applySuspend { it() }.build() }
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param argument The list of roles in the cluster.
     */
    @JvmName("qwtnwjjtfjshilhx")
    public suspend fun roles(argument: suspend RoleArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(RoleArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.roles = mapped
    }

    /**
     * @param values The list of roles in the cluster.
     */
    @JvmName("cbgpixkkhrbxasml")
    public suspend fun roles(vararg values: RoleArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.roles = mapped
    }

    internal fun build(): ComputeProfileArgs = ComputeProfileArgs(
        roles = roles,
    )
}
