@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.DiskEncryptionPropertiesArgs.builder
import com.pulumi.azurenative.hdinsight.kotlin.enums.JsonWebKeyEncryptionAlgorithm
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The disk encryption properties
 * @property encryptionAlgorithm Algorithm identifier for encryption, default RSA-OAEP.
 * @property encryptionAtHost Indicates whether or not resource disk encryption is enabled.
 * @property keyName Key name that is used for enabling disk encryption.
 * @property keyVersion Specific key version that is used for enabling disk encryption.
 * @property msiResourceId Resource ID of Managed Identity that is used to access the key vault.
 * @property vaultUri Base key vault URI where the customers key is located eg. https://myvault.vault.azure.net
 */
public data class DiskEncryptionPropertiesArgs(
    public val encryptionAlgorithm: Output<Either<String, JsonWebKeyEncryptionAlgorithm>>? = null,
    public val encryptionAtHost: Output<Boolean>? = null,
    public val keyName: Output<String>? = null,
    public val keyVersion: Output<String>? = null,
    public val msiResourceId: Output<String>? = null,
    public val vaultUri: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.DiskEncryptionPropertiesArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.DiskEncryptionPropertiesArgs =
        com.pulumi.azurenative.hdinsight.inputs.DiskEncryptionPropertiesArgs.builder()
            .encryptionAlgorithm(
                encryptionAlgorithm?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .encryptionAtHost(encryptionAtHost?.applyValue({ args0 -> args0 }))
            .keyName(keyName?.applyValue({ args0 -> args0 }))
            .keyVersion(keyVersion?.applyValue({ args0 -> args0 }))
            .msiResourceId(msiResourceId?.applyValue({ args0 -> args0 }))
            .vaultUri(vaultUri?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DiskEncryptionPropertiesArgs].
 */
@PulumiTagMarker
public class DiskEncryptionPropertiesArgsBuilder internal constructor() {
    private var encryptionAlgorithm: Output<Either<String, JsonWebKeyEncryptionAlgorithm>>? = null

    private var encryptionAtHost: Output<Boolean>? = null

    private var keyName: Output<String>? = null

    private var keyVersion: Output<String>? = null

    private var msiResourceId: Output<String>? = null

    private var vaultUri: Output<String>? = null

    /**
     * @param value Algorithm identifier for encryption, default RSA-OAEP.
     */
    @JvmName("uqsqvkjarqtxburp")
    public suspend fun encryptionAlgorithm(`value`: Output<Either<String, JsonWebKeyEncryptionAlgorithm>>) {
        this.encryptionAlgorithm = value
    }

    /**
     * @param value Indicates whether or not resource disk encryption is enabled.
     */
    @JvmName("trxhpmsxdbnaslvb")
    public suspend fun encryptionAtHost(`value`: Output<Boolean>) {
        this.encryptionAtHost = value
    }

    /**
     * @param value Key name that is used for enabling disk encryption.
     */
    @JvmName("fcdyifmnsvhagtoe")
    public suspend fun keyName(`value`: Output<String>) {
        this.keyName = value
    }

    /**
     * @param value Specific key version that is used for enabling disk encryption.
     */
    @JvmName("nrgsppnixvnqtcmo")
    public suspend fun keyVersion(`value`: Output<String>) {
        this.keyVersion = value
    }

    /**
     * @param value Resource ID of Managed Identity that is used to access the key vault.
     */
    @JvmName("ebrcjwimhhhxibxi")
    public suspend fun msiResourceId(`value`: Output<String>) {
        this.msiResourceId = value
    }

    /**
     * @param value Base key vault URI where the customers key is located eg. https://myvault.vault.azure.net
     */
    @JvmName("nfsfckrtbjmnwggj")
    public suspend fun vaultUri(`value`: Output<String>) {
        this.vaultUri = value
    }

    /**
     * @param value Algorithm identifier for encryption, default RSA-OAEP.
     */
    @JvmName("qybwhctfiwystrrq")
    public suspend fun encryptionAlgorithm(`value`: Either<String, JsonWebKeyEncryptionAlgorithm>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionAlgorithm = mapped
    }

    /**
     * @param value Algorithm identifier for encryption, default RSA-OAEP.
     */
    @JvmName("cpjsfhgarxoulafy")
    public fun encryptionAlgorithm(`value`: String) {
        val toBeMapped = Either.ofLeft<String, JsonWebKeyEncryptionAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionAlgorithm = mapped
    }

    /**
     * @param value Algorithm identifier for encryption, default RSA-OAEP.
     */
    @JvmName("hqyxirgombfolpun")
    public fun encryptionAlgorithm(`value`: JsonWebKeyEncryptionAlgorithm) {
        val toBeMapped = Either.ofRight<String, JsonWebKeyEncryptionAlgorithm>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.encryptionAlgorithm = mapped
    }

    /**
     * @param value Indicates whether or not resource disk encryption is enabled.
     */
    @JvmName("sqyviqocabrqtjfh")
    public suspend fun encryptionAtHost(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionAtHost = mapped
    }

    /**
     * @param value Key name that is used for enabling disk encryption.
     */
    @JvmName("tovlntoimgxekewk")
    public suspend fun keyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyName = mapped
    }

    /**
     * @param value Specific key version that is used for enabling disk encryption.
     */
    @JvmName("utpicggtrbhxilgi")
    public suspend fun keyVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyVersion = mapped
    }

    /**
     * @param value Resource ID of Managed Identity that is used to access the key vault.
     */
    @JvmName("jbrydrvqvdixeifa")
    public suspend fun msiResourceId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.msiResourceId = mapped
    }

    /**
     * @param value Base key vault URI where the customers key is located eg. https://myvault.vault.azure.net
     */
    @JvmName("qccmbiimpihmddsy")
    public suspend fun vaultUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vaultUri = mapped
    }

    internal fun build(): DiskEncryptionPropertiesArgs = DiskEncryptionPropertiesArgs(
        encryptionAlgorithm = encryptionAlgorithm,
        encryptionAtHost = encryptionAtHost,
        keyName = keyName,
        keyVersion = keyVersion,
        msiResourceId = msiResourceId,
        vaultUri = vaultUri,
    )
}
