@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.inputs

import com.pulumi.azurenative.hdinsight.inputs.ResourceIdArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The azure resource id.
 * @property id The azure resource id.
 */
public data class ResourceIdArgs(
    public val id: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.hdinsight.inputs.ResourceIdArgs> {
    override fun toJava(): com.pulumi.azurenative.hdinsight.inputs.ResourceIdArgs =
        com.pulumi.azurenative.hdinsight.inputs.ResourceIdArgs.builder()
            .id(id?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ResourceIdArgs].
 */
@PulumiTagMarker
public class ResourceIdArgsBuilder internal constructor() {
    private var id: Output<String>? = null

    /**
     * @param value The azure resource id.
     */
    @JvmName("cliwrnangqoesovd")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The azure resource id.
     */
    @JvmName("vjnbmuvnmvreeqpg")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    internal fun build(): ResourceIdArgs = ResourceIdArgs(
        id = id,
    )
}
