@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Identity properties of the AKS cluster agentpool MSI
 * @property msiClientId ClientId of the MSI.
 * @property msiObjectId ObjectId of the MSI.
 * @property msiResourceId ResourceId of the MSI.
 */
public data class AksClusterProfileResponseAksClusterAgentPoolIdentityProfile(
    public val msiClientId: String,
    public val msiObjectId: String,
    public val msiResourceId: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.AksClusterProfileResponseAksClusterAgentPoolIdentityProfile): AksClusterProfileResponseAksClusterAgentPoolIdentityProfile =
            AksClusterProfileResponseAksClusterAgentPoolIdentityProfile(
                msiClientId = javaType.msiClientId(),
                msiObjectId = javaType.msiObjectId(),
                msiResourceId = javaType.msiResourceId(),
            )
    }
}
