@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * Gets the application SSH endpoint
 * @property destinationPort The destination port to connect to.
 * @property location The location of the endpoint.
 * @property privateIPAddress The private ip address of the endpoint.
 * @property publicPort The public port to connect to.
 */
public data class ApplicationGetEndpointResponse(
    public val destinationPort: Int? = null,
    public val location: String? = null,
    public val privateIPAddress: String? = null,
    public val publicPort: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.ApplicationGetEndpointResponse): ApplicationGetEndpointResponse = ApplicationGetEndpointResponse(
            destinationPort = javaType.destinationPort().map({ args0 -> args0 }).orElse(null),
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            privateIPAddress = javaType.privateIPAddress().map({ args0 -> args0 }).orElse(null),
            publicPort = javaType.publicPort().map({ args0 -> args0 }).orElse(null),
        )
    }
}
