@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * The HDInsight cluster application GET response.
 * @property applicationState The application state.
 * @property applicationType The application type.
 * @property computeProfile The list of roles in the cluster.
 * @property createdDate The application create date time.
 * @property errors The list of errors.
 * @property httpsEndpoints The list of application HTTPS endpoints.
 * @property installScriptActions The list of install script actions.
 * @property marketplaceIdentifier The marketplace identifier.
 * @property privateLinkConfigurations The private link configurations.
 * @property provisioningState The provisioning state of the application.
 * @property sshEndpoints The list of application SSH endpoints.
 * @property uninstallScriptActions The list of uninstall script actions.
 */
public data class ApplicationPropertiesResponse(
    public val applicationState: String,
    public val applicationType: String? = null,
    public val computeProfile: ComputeProfileResponse? = null,
    public val createdDate: String,
    public val errors: List<ErrorsResponse>? = null,
    public val httpsEndpoints: List<ApplicationGetHttpsEndpointResponse>? = null,
    public val installScriptActions: List<RuntimeScriptActionResponse>? = null,
    public val marketplaceIdentifier: String,
    public val privateLinkConfigurations: List<PrivateLinkConfigurationResponse>? = null,
    public val provisioningState: String,
    public val sshEndpoints: List<ApplicationGetEndpointResponse>? = null,
    public val uninstallScriptActions: List<RuntimeScriptActionResponse>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.ApplicationPropertiesResponse): ApplicationPropertiesResponse = ApplicationPropertiesResponse(
            applicationState = javaType.applicationState(),
            applicationType = javaType.applicationType().map({ args0 -> args0 }).orElse(null),
            computeProfile = javaType.computeProfile().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.ComputeProfileResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            createdDate = javaType.createdDate(),
            errors = javaType.errors().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.ErrorsResponse.Companion.toKotlin(args0)
                })
            }),
            httpsEndpoints = javaType.httpsEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.ApplicationGetHttpsEndpointResponse.Companion.toKotlin(args0)
                })
            }),
            installScriptActions = javaType.installScriptActions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.RuntimeScriptActionResponse.Companion.toKotlin(args0)
                })
            }),
            marketplaceIdentifier = javaType.marketplaceIdentifier(),
            privateLinkConfigurations = javaType.privateLinkConfigurations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.PrivateLinkConfigurationResponse.Companion.toKotlin(args0)
                })
            }),
            provisioningState = javaType.provisioningState(),
            sshEndpoints = javaType.sshEndpoints().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.ApplicationGetEndpointResponse.Companion.toKotlin(args0)
                })
            }),
            uninstallScriptActions = javaType.uninstallScriptActions().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.RuntimeScriptActionResponse.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
