@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.Suppress

/**
 * The autoscale request parameters
 * @property capacity Parameters for load-based autoscale
 * @property recurrence Parameters for schedule-based autoscale
 */
public data class AutoscaleResponse(
    public val capacity: AutoscaleCapacityResponse? = null,
    public val recurrence: AutoscaleRecurrenceResponse? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.AutoscaleResponse): AutoscaleResponse = AutoscaleResponse(
            capacity = javaType.capacity().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.AutoscaleCapacityResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            recurrence = javaType.recurrence().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.AutoscaleRecurrenceResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
