@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 * The cluster definition.
 * @property blueprint The link to the blueprint.
 * @property componentVersion The versions of different services in the cluster.
 * @property configurations The cluster configurations.
 * @property kind The type of cluster.
 */
public data class ClusterDefinitionResponse(
    public val blueprint: String? = null,
    public val componentVersion: Map<String, String>? = null,
    public val configurations: Any? = null,
    public val kind: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.ClusterDefinitionResponse): ClusterDefinitionResponse = ClusterDefinitionResponse(
            blueprint = javaType.blueprint().map({ args0 -> args0 }).orElse(null),
            componentVersion = javaType.componentVersion().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            configurations = javaType.configurations().map({ args0 -> args0 }).orElse(null),
            kind = javaType.kind().map({ args0 -> args0 }).orElse(null),
        )
    }
}
