@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * Properties of underlying AKS cluster.
 * @property aksClusterAgentPoolIdentityProfile Identity properties of the AKS cluster agentpool MSI
 * @property aksClusterResourceId ARM Resource ID of the AKS cluster
 * @property aksVersion AKS control plane and default node pool version of this ClusterPool
 */
public data class ClusterPoolResourcePropertiesResponseAksClusterProfile(
    public val aksClusterAgentPoolIdentityProfile: AksClusterProfileResponseAksClusterAgentPoolIdentityProfile? = null,
    public val aksClusterResourceId: String? = null,
    public val aksVersion: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.ClusterPoolResourcePropertiesResponseAksClusterProfile): ClusterPoolResourcePropertiesResponseAksClusterProfile =
            ClusterPoolResourcePropertiesResponseAksClusterProfile(
                aksClusterAgentPoolIdentityProfile = javaType.aksClusterAgentPoolIdentityProfile().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.azurenative.hdinsight.kotlin.outputs.AksClusterProfileResponseAksClusterAgentPoolIdentityProfile.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                aksClusterResourceId = javaType.aksClusterResourceId().map({ args0 -> args0 }).orElse(null),
                aksVersion = javaType.aksVersion(),
            )
    }
}
