@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 * The connectivity properties
 * @property location The location of the endpoint.
 * @property name The name of the endpoint.
 * @property port The port to connect to.
 * @property privateIPAddress The private ip address of the endpoint.
 * @property protocol The protocol of the endpoint.
 */
public data class ConnectivityEndpointResponse(
    public val location: String? = null,
    public val name: String? = null,
    public val port: Int? = null,
    public val privateIPAddress: String? = null,
    public val protocol: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.ConnectivityEndpointResponse): ConnectivityEndpointResponse = ConnectivityEndpointResponse(
            location = javaType.location().map({ args0 -> args0 }).orElse(null),
            name = javaType.name().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            privateIPAddress = javaType.privateIPAddress().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
        )
    }
}
