@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The configuration that services will be excluded when creating cluster.
 * @property excludedServicesConfigId The config id of excluded services.
 * @property excludedServicesList The list of excluded services.
 */
public data class ExcludedServicesConfigResponse(
    public val excludedServicesConfigId: String? = null,
    public val excludedServicesList: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.ExcludedServicesConfigResponse): ExcludedServicesConfigResponse = ExcludedServicesConfigResponse(
            excludedServicesConfigId = javaType.excludedServicesConfigId().map({ args0 -> args0 }).orElse(null),
            excludedServicesList = javaType.excludedServicesList().map({ args0 -> args0 }).orElse(null),
        )
    }
}
