@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.hdinsight.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress

/**
 * The ip configurations for the private link service.
 * @property id The private link IP configuration id.
 * @property name The name of private link IP configuration.
 * @property primary Indicates whether this IP configuration is primary for the corresponding NIC.
 * @property privateIPAddress The IP address.
 * @property privateIPAllocationMethod The method that private IP address is allocated.
 * @property provisioningState The private link configuration provisioning state, which only appears in the response.
 * @property subnet The subnet resource id.
 * @property type The type of the private link IP configuration.
 */
public data class IPConfigurationResponse(
    public val id: String,
    public val name: String,
    public val primary: Boolean? = null,
    public val privateIPAddress: String? = null,
    public val privateIPAllocationMethod: String? = null,
    public val provisioningState: String,
    public val subnet: ResourceIdResponse? = null,
    public val type: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.hdinsight.outputs.IPConfigurationResponse): IPConfigurationResponse = IPConfigurationResponse(
            id = javaType.id(),
            name = javaType.name(),
            primary = javaType.primary().map({ args0 -> args0 }).orElse(null),
            privateIPAddress = javaType.privateIPAddress().map({ args0 -> args0 }).orElse(null),
            privateIPAllocationMethod = javaType.privateIPAllocationMethod().map({ args0 ->
                args0
            }).orElse(null),
            provisioningState = javaType.provisioningState(),
            subnet = javaType.subnet().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.azurenative.hdinsight.kotlin.outputs.ResourceIdResponse.Companion.toKotlin(args0)
                })
            }).orElse(null),
            type = javaType.type(),
        )
    }
}
